/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.serialization.json;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Date;
import org.restexpress.ContentType;
import org.restexpress.serialization.json.GsonEncodingStringSerializer;
import org.restexpress.serialization.json.GsonTimepointSerializer;
import org.restexpress.serialization.json.JsonSerializationProcessor;

public class GsonJsonProcessor
extends JsonSerializationProcessor {
    private static final byte[] EMPTY_STRING_BYTES = "".getBytes(ContentType.CHARSET);
    private Gson gson;

    public GsonJsonProcessor() {
        this(true);
    }

    public GsonJsonProcessor(boolean shouldOutboundEncode) {
        GsonBuilder builder = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (Object)new GsonTimepointSerializer()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        if (shouldOutboundEncode) {
            builder.registerTypeAdapter(String.class, (Object)new GsonEncodingStringSerializer());
        }
        this.gson = builder.create();
    }

    public GsonJsonProcessor(Gson gson) {
        this.gson = gson;
    }

    @Override
    public <T> T deserialize(String string, Class<T> type) {
        return (T)this.gson.fromJson(string, type);
    }

    @Override
    public <T> T deserialize(ByteBuf buffer, Class<T> type) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader((InputStream)new ByteBufInputStream(buffer), ContentType.CHARSET), type);
    }

    @Override
    public ByteBuffer serialize(Object object) {
        if (object == null) {
            return ByteBuffer.wrap(EMPTY_STRING_BYTES);
        }
        return ByteBuffer.wrap(this.gson.toJson(object).getBytes(ContentType.CHARSET));
    }
}

