/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Order;
import com.stripe.model.OrderItem;
import com.stripe.model.OrderReturnCollection;
import com.stripe.model.Refund;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.OrderReturnListParams;
import com.stripe.param.OrderReturnRetrieveParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class OrderReturn
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="items")
    List<OrderItem> items;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="order")
    ExpandableField<Order> order;
    @SerializedName(value="refund")
    ExpandableField<Refund> refund;

    public String getOrder() {
        return this.order != null ? this.order.getId() : null;
    }

    public void setOrder(String id) {
        this.order = ApiResource.setExpandableFieldId(id, this.order);
    }

    public Order getOrderObject() {
        return this.order != null ? this.order.getExpanded() : null;
    }

    public void setOrderObject(Order expandableObject) {
        this.order = new ExpandableField<Order>(expandableObject.getId(), expandableObject);
    }

    public String getRefund() {
        return this.refund != null ? this.refund.getId() : null;
    }

    public void setRefund(String id) {
        this.refund = ApiResource.setExpandableFieldId(id, this.refund);
    }

    public Refund getRefundObject() {
        return this.refund != null ? this.refund.getExpanded() : null;
    }

    public void setRefundObject(Refund expandableObject) {
        this.refund = new ExpandableField<Refund>(expandableObject.getId(), expandableObject);
    }

    public static OrderReturnCollection list(Map<String, Object> params) throws StripeException {
        return OrderReturn.list(params, (RequestOptions)null);
    }

    public static OrderReturnCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/order_returns");
        return ApiResource.requestCollection(url, params, OrderReturnCollection.class, options);
    }

    public static OrderReturnCollection list(OrderReturnListParams params) throws StripeException {
        return OrderReturn.list(params, (RequestOptions)null);
    }

    public static OrderReturnCollection list(OrderReturnListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/order_returns");
        return ApiResource.requestCollection(url, params, OrderReturnCollection.class, options);
    }

    public static OrderReturn retrieve(String id) throws StripeException {
        return OrderReturn.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static OrderReturn retrieve(String id, RequestOptions options) throws StripeException {
        return OrderReturn.retrieve(id, (Map<String, Object>)null, options);
    }

    public static OrderReturn retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/order_returns/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, OrderReturn.class, options);
    }

    public static OrderReturn retrieve(String id, OrderReturnRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/order_returns/%s", ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, OrderReturn.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public List<OrderItem> getItems() {
        return this.items;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setItems(List<OrderItem> items) {
        this.items = items;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderReturn)) {
            return false;
        }
        OrderReturn other = (OrderReturn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<OrderItem> this$items = this.getItems();
        List<OrderItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$order = this.getOrder();
        String other$order = other.getOrder();
        if (this$order == null ? other$order != null : !this$order.equals(other$order)) {
            return false;
        }
        String this$refund = this.getRefund();
        String other$refund = other.getRefund();
        return !(this$refund == null ? other$refund != null : !this$refund.equals(other$refund));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OrderReturn;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<OrderItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : $order.hashCode());
        String $refund = this.getRefund();
        result = result * 59 + ($refund == null ? 43 : $refund.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

