/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.net.HttpHeaders;
import com.stripe.net.StripeResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;

class RequestTelemetry {
    public static final String HEADER_NAME = "X-Stripe-Client-Telemetry";
    private static final int MAX_REQUEST_METRICS_QUEUE_SIZE = 100;
    private static final Gson gson = new Gson();
    private static ConcurrentLinkedQueue<RequestMetrics> prevRequestMetrics = new ConcurrentLinkedQueue();

    RequestTelemetry() {
    }

    public Optional<String> getHeaderValue(HttpHeaders headers) {
        if (headers.firstValue(HEADER_NAME).isPresent()) {
            return Optional.empty();
        }
        RequestMetrics requestMetrics = prevRequestMetrics.poll();
        if (requestMetrics == null) {
            return Optional.empty();
        }
        if (!Stripe.enableTelemetry) {
            return Optional.empty();
        }
        ClientTelemetryPayload payload = new ClientTelemetryPayload(requestMetrics);
        return Optional.of(gson.toJson((Object)payload));
    }

    public void maybeEnqueueMetrics(StripeResponse response, Duration duration) {
        if (!Stripe.enableTelemetry) {
            return;
        }
        if (response.requestId() == null) {
            return;
        }
        if (prevRequestMetrics.size() >= 100) {
            return;
        }
        RequestMetrics metrics = new RequestMetrics(response.requestId(), duration.toMillis());
        prevRequestMetrics.add(metrics);
    }

    private static class RequestMetrics {
        @SerializedName(value="request_id")
        private final String requestId;
        @SerializedName(value="request_duration_ms")
        private final long requestDurationMs;

        @Generated
        public RequestMetrics(String requestId, long requestDurationMs) {
            this.requestId = requestId;
            this.requestDurationMs = requestDurationMs;
        }

        @Generated
        public String getRequestId() {
            return this.requestId;
        }

        @Generated
        public long getRequestDurationMs() {
            return this.requestDurationMs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestMetrics)) {
                return false;
            }
            RequestMetrics other = (RequestMetrics)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$requestId = this.getRequestId();
            String other$requestId = other.getRequestId();
            if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
                return false;
            }
            return this.getRequestDurationMs() == other.getRequestDurationMs();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RequestMetrics;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $requestId = this.getRequestId();
            result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
            long $requestDurationMs = this.getRequestDurationMs();
            result = result * 59 + (int)($requestDurationMs >>> 32 ^ $requestDurationMs);
            return result;
        }

        @Generated
        public String toString() {
            return "RequestTelemetry.RequestMetrics(requestId=" + this.getRequestId() + ", requestDurationMs=" + this.getRequestDurationMs() + ")";
        }
    }

    private static class ClientTelemetryPayload {
        @SerializedName(value="last_request_metrics")
        private final RequestMetrics lastRequestMetrics;

        @Generated
        public ClientTelemetryPayload(RequestMetrics lastRequestMetrics) {
            this.lastRequestMetrics = lastRequestMetrics;
        }

        @Generated
        public RequestMetrics getLastRequestMetrics() {
            return this.lastRequestMetrics;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientTelemetryPayload)) {
                return false;
            }
            ClientTelemetryPayload other = (ClientTelemetryPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RequestMetrics this$lastRequestMetrics = this.getLastRequestMetrics();
            RequestMetrics other$lastRequestMetrics = other.getLastRequestMetrics();
            return !(this$lastRequestMetrics == null ? other$lastRequestMetrics != null : !((Object)this$lastRequestMetrics).equals(other$lastRequestMetrics));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientTelemetryPayload;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RequestMetrics $lastRequestMetrics = this.getLastRequestMetrics();
            result = result * 59 + ($lastRequestMetrics == null ? 43 : ((Object)$lastRequestMetrics).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RequestTelemetry.ClientTelemetryPayload(lastRequestMetrics=" + this.getLastRequestMetrics() + ")";
        }
    }
}

