/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ApplicationFee;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.ExpandableField;
import com.stripe.model.MetadataStore;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.FeeRefundUpdateParams;
import java.util.Map;
import lombok.Generated;

public class FeeRefund
extends ApiResource
implements MetadataStore<FeeRefund>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="fee")
    ExpandableField<ApplicationFee> fee;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public String getFee() {
        return this.fee != null ? this.fee.getId() : null;
    }

    public void setFee(String id) {
        this.fee = ApiResource.setExpandableFieldId(id, this.fee);
    }

    public ApplicationFee getFeeObject() {
        return this.fee != null ? this.fee.getExpanded() : null;
    }

    public void setFeeObject(ApplicationFee expandableObject) {
        this.fee = new ExpandableField<ApplicationFee>(expandableObject.getId(), expandableObject);
    }

    public FeeRefund update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public FeeRefund update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/application_fees/%s/refunds/%s", ApiResource.urlEncodeId(this.getFee()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FeeRefund.class, options);
    }

    public FeeRefund update(FeeRefundUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public FeeRefund update(FeeRefundUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/application_fees/%s/refunds/%s", ApiResource.urlEncodeId(this.getFee()), ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FeeRefund.class, options);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeeRefund)) {
            return false;
        }
        FeeRefund other = (FeeRefund)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$fee = this.getFee();
        String other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !this$fee.equals(other$fee)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeeRefund;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : $fee.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

