/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.issuing.DisputeCollection;
import com.stripe.model.issuing.Transaction;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.issuing.DisputeCreateParams;
import com.stripe.param.issuing.DisputeListParams;
import com.stripe.param.issuing.DisputeRetrieveParams;
import com.stripe.param.issuing.DisputeUpdateParams;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Dispute
extends ApiResource
implements HasId {
    @SerializedName(value="balance_transactions")
    List<BalanceTransaction> balanceTransactions;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="transaction")
    ExpandableField<Transaction> transaction;

    public String getTransaction() {
        return this.transaction != null ? this.transaction.getId() : null;
    }

    public void setTransaction(String id) {
        this.transaction = ApiResource.setExpandableFieldId(id, this.transaction);
    }

    public Transaction getTransactionObject() {
        return this.transaction != null ? this.transaction.getExpanded() : null;
    }

    public void setTransactionObject(Transaction expandableObject) {
        this.transaction = new ExpandableField<Transaction>(expandableObject.getId(), expandableObject);
    }

    public static DisputeCollection list(Map<String, Object> params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
    }

    public static DisputeCollection list(DisputeListParams params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(DisputeListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return ApiResource.requestCollection(url, params, DisputeCollection.class, options);
    }

    public static Dispute create(Map<String, Object> params) throws StripeException {
        return Dispute.create(params, (RequestOptions)null);
    }

    public static Dispute create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public static Dispute create(DisputeCreateParams params) throws StripeException {
        return Dispute.create(params, (RequestOptions)null);
    }

    public static Dispute create(DisputeCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/issuing/disputes");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public Dispute update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public Dispute update(DisputeUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Dispute update(DisputeUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, Dispute.class, options);
    }

    public static Dispute retrieve(String dispute) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, options);
    }

    public static Dispute retrieve(String dispute, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
    }

    public static Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/issuing/disputes/%s", ApiResource.urlEncodeId(dispute)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, Dispute.class, options);
    }

    @Generated
    public List<BalanceTransaction> getBalanceTransactions() {
        return this.balanceTransactions;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setBalanceTransactions(List<BalanceTransaction> balanceTransactions) {
        this.balanceTransactions = balanceTransactions;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<BalanceTransaction> this$balanceTransactions = this.getBalanceTransactions();
        List<BalanceTransaction> other$balanceTransactions = other.getBalanceTransactions();
        if (this$balanceTransactions == null ? other$balanceTransactions != null : !((Object)this$balanceTransactions).equals(other$balanceTransactions)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$transaction = this.getTransaction();
        String other$transaction = other.getTransaction();
        return !(this$transaction == null ? other$transaction != null : !this$transaction.equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dispute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<BalanceTransaction> $balanceTransactions = this.getBalanceTransactions();
        result = result * 59 + ($balanceTransactions == null ? 43 : ((Object)$balanceTransactions).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : $transaction.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

