/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.net.HttpHeaders;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public final class StripeResponse {
    private final int code;
    private final HttpHeaders headers;
    private final String body;
    private int numRetries;

    public StripeResponse(int code, HttpHeaders headers, String body) {
        Objects.requireNonNull(headers);
        Objects.requireNonNull(body);
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    public Instant date() {
        Optional<String> dateStr = this.headers.firstValue("Date");
        if (!dateStr.isPresent()) {
            return null;
        }
        return ZonedDateTime.parse(dateStr.get(), DateTimeFormatter.RFC_1123_DATE_TIME).toInstant();
    }

    public String idempotencyKey() {
        return this.headers.firstValue("Idempotency-Key").orElse(null);
    }

    public String requestId() {
        return this.headers.firstValue("Request-Id").orElse(null);
    }

    @Generated
    public int code() {
        return this.code;
    }

    @Generated
    public HttpHeaders headers() {
        return this.headers;
    }

    @Generated
    public String body() {
        return this.body;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StripeResponse)) {
            return false;
        }
        StripeResponse other = (StripeResponse)o;
        if (this.code() != other.code()) {
            return false;
        }
        HttpHeaders this$headers = this.headers();
        HttpHeaders other$headers = other.headers();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$body = this.body();
        String other$body = other.body();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        return this.numRetries() == other.numRetries();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code();
        HttpHeaders $headers = this.headers();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $body = this.body();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        result = result * 59 + this.numRetries();
        return result;
    }

    @Generated
    public String toString() {
        return "StripeResponse(code=" + this.code() + ", headers=" + this.headers() + ", body=" + this.body() + ", numRetries=" + this.numRetries() + ")";
    }

    @Generated
    int numRetries() {
        return this.numRetries;
    }

    @Generated
    StripeResponse numRetries(int numRetries) {
        this.numRetries = numRetries;
        return this;
    }
}

