/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.TransferReversal;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.TransferReversalCollectionCreateParams;
import com.stripe.param.TransferReversalCollectionListParams;
import com.stripe.param.TransferReversalCollectionRetrieveParams;
import java.util.Map;

public class TransferReversalCollection
extends StripeCollection<TransferReversal> {
    public TransferReversal create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public TransferReversal create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TransferReversal.class, options);
    }

    public TransferReversal create(TransferReversalCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public TransferReversal create(TransferReversalCollectionCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, TransferReversal.class, options);
    }

    public TransferReversalCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public TransferReversalCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.requestCollection(url, params, TransferReversalCollection.class, options);
    }

    public TransferReversalCollection list(TransferReversalCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public TransferReversalCollection list(TransferReversalCollectionListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), this.getUrl());
        return ApiResource.requestCollection(url, params, TransferReversalCollection.class, options);
    }

    public TransferReversal retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public TransferReversal retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public TransferReversal retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TransferReversal.class, options);
    }

    public TransferReversal retrieve(String id, TransferReversalCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, TransferReversal.class, options);
    }
}

