/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.net;

import com.stripe.Stripe;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import lombok.Generated;

public class RequestOptions {
    private final String apiKey;
    private final String clientId;
    private final String idempotencyKey;
    private final String stripeAccount;
    private final String stripeVersion = "2020-08-27";
    private final String stripeVersionOverride;
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxNetworkRetries;
    private final Proxy connectionProxy;
    private final PasswordAuthentication proxyCredential;

    public static RequestOptions getDefault() {
        return new RequestOptions(Stripe.apiKey, Stripe.clientId, null, null, null, Stripe.getConnectTimeout(), Stripe.getReadTimeout(), Stripe.getMaxNetworkRetries(), Stripe.getConnectionProxy(), Stripe.getProxyCredential());
    }

    private RequestOptions(String apiKey, String clientId, String idempotencyKey, String stripeAccount, String stripeVersionOverride, int connectTimeout, int readTimeout, int maxNetworkRetries, Proxy connectionProxy, PasswordAuthentication proxyCredential) {
        this.apiKey = apiKey;
        this.clientId = clientId;
        this.idempotencyKey = idempotencyKey;
        this.stripeAccount = stripeAccount;
        this.stripeVersionOverride = stripeVersionOverride;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxNetworkRetries = maxNetworkRetries;
        this.connectionProxy = connectionProxy;
        this.proxyCredential = proxyCredential;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public String getStripeAccount() {
        return this.stripeAccount;
    }

    public String getStripeVersion() {
        return "2020-08-27";
    }

    public String getStripeVersionOverride() {
        return this.stripeVersionOverride;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getMaxNetworkRetries() {
        return this.maxNetworkRetries;
    }

    public Proxy getConnectionProxy() {
        return this.connectionProxy;
    }

    public PasswordAuthentication getProxyCredential() {
        return this.proxyCredential;
    }

    public static RequestOptionsBuilder builder() {
        return new RequestOptionsBuilder();
    }

    public RequestOptionsBuilder toBuilder() {
        return new RequestOptionsBuilder().setApiKey(this.apiKey).setStripeAccount(this.stripeAccount);
    }

    private static String normalizeApiKey(String apiKey) {
        if (apiKey == null) {
            return null;
        }
        String normalized = apiKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty API key specified!");
        }
        return normalized;
    }

    private static String normalizeClientId(String clientId) {
        if (clientId == null) {
            return null;
        }
        String normalized = clientId.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty client_id specified!");
        }
        return normalized;
    }

    private static String normalizeStripeVersion(String stripeVersion) {
        if (stripeVersion == null) {
            return null;
        }
        String normalized = stripeVersion.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Stripe version specified!");
        }
        return normalized;
    }

    private static String normalizeIdempotencyKey(String idempotencyKey) {
        if (idempotencyKey == null) {
            return null;
        }
        String normalized = idempotencyKey.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty Idempotency Key Specified!");
        }
        if (normalized.length() > 255) {
            throw new InvalidRequestOptionsException(String.format("Idempotency Key length was %d, which is larger than the 255 character maximum!", normalized.length()));
        }
        return normalized;
    }

    private static String normalizeStripeAccount(String stripeAccount) {
        if (stripeAccount == null) {
            return null;
        }
        String normalized = stripeAccount.trim();
        if (normalized.isEmpty()) {
            throw new InvalidRequestOptionsException("Empty stripe account specified!");
        }
        return normalized;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestOptions)) {
            return false;
        }
        RequestOptions other = (RequestOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getMaxNetworkRetries() != other.getMaxNetworkRetries()) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$idempotencyKey = this.getIdempotencyKey();
        String other$idempotencyKey = other.getIdempotencyKey();
        if (this$idempotencyKey == null ? other$idempotencyKey != null : !this$idempotencyKey.equals(other$idempotencyKey)) {
            return false;
        }
        String this$stripeAccount = this.getStripeAccount();
        String other$stripeAccount = other.getStripeAccount();
        if (this$stripeAccount == null ? other$stripeAccount != null : !this$stripeAccount.equals(other$stripeAccount)) {
            return false;
        }
        String this$stripeVersion = this.getStripeVersion();
        String other$stripeVersion = other.getStripeVersion();
        if (this$stripeVersion == null ? other$stripeVersion != null : !this$stripeVersion.equals(other$stripeVersion)) {
            return false;
        }
        String this$stripeVersionOverride = this.getStripeVersionOverride();
        String other$stripeVersionOverride = other.getStripeVersionOverride();
        if (this$stripeVersionOverride == null ? other$stripeVersionOverride != null : !this$stripeVersionOverride.equals(other$stripeVersionOverride)) {
            return false;
        }
        Proxy this$connectionProxy = this.getConnectionProxy();
        Proxy other$connectionProxy = other.getConnectionProxy();
        if (this$connectionProxy == null ? other$connectionProxy != null : !((Object)this$connectionProxy).equals(other$connectionProxy)) {
            return false;
        }
        PasswordAuthentication this$proxyCredential = this.getProxyCredential();
        PasswordAuthentication other$proxyCredential = other.getProxyCredential();
        return !(this$proxyCredential == null ? other$proxyCredential != null : !this$proxyCredential.equals(other$proxyCredential));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getMaxNetworkRetries();
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $idempotencyKey = this.getIdempotencyKey();
        result = result * 59 + ($idempotencyKey == null ? 43 : $idempotencyKey.hashCode());
        String $stripeAccount = this.getStripeAccount();
        result = result * 59 + ($stripeAccount == null ? 43 : $stripeAccount.hashCode());
        String $stripeVersion = this.getStripeVersion();
        result = result * 59 + ($stripeVersion == null ? 43 : $stripeVersion.hashCode());
        String $stripeVersionOverride = this.getStripeVersionOverride();
        result = result * 59 + ($stripeVersionOverride == null ? 43 : $stripeVersionOverride.hashCode());
        Proxy $connectionProxy = this.getConnectionProxy();
        result = result * 59 + ($connectionProxy == null ? 43 : ((Object)$connectionProxy).hashCode());
        PasswordAuthentication $proxyCredential = this.getProxyCredential();
        result = result * 59 + ($proxyCredential == null ? 43 : $proxyCredential.hashCode());
        return result;
    }

    public static class InvalidRequestOptionsException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidRequestOptionsException(String message) {
            super(message);
        }
    }

    public static final class RequestOptionsBuilder {
        private String apiKey = Stripe.apiKey;
        private String clientId = Stripe.clientId;
        private String idempotencyKey;
        private String stripeAccount;
        private String stripeVersionOverride;
        private int connectTimeout = Stripe.getConnectTimeout();
        private int readTimeout = Stripe.getReadTimeout();
        private int maxNetworkRetries = Stripe.getMaxNetworkRetries();
        private Proxy connectionProxy = Stripe.getConnectionProxy();
        private PasswordAuthentication proxyCredential = Stripe.getProxyCredential();

        public String getApiKey() {
            return this.apiKey;
        }

        public RequestOptionsBuilder setApiKey(String apiKey) {
            this.apiKey = RequestOptions.normalizeApiKey(apiKey);
            return this;
        }

        public RequestOptionsBuilder clearApiKey() {
            this.apiKey = null;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public RequestOptionsBuilder setClientId(String clientId) {
            this.clientId = RequestOptions.normalizeClientId(clientId);
            return this;
        }

        public RequestOptionsBuilder clearClientId() {
            this.clientId = null;
            return this;
        }

        public RequestOptionsBuilder setIdempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public RequestOptionsBuilder setConnectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public RequestOptionsBuilder setReadTimeout(int timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public int getMaxNetworkRetries() {
            return this.maxNetworkRetries;
        }

        public RequestOptionsBuilder setMaxNetworkRetries(int maxNetworkRetries) {
            this.maxNetworkRetries = maxNetworkRetries;
            return this;
        }

        public Proxy getConnectionProxy() {
            return this.connectionProxy;
        }

        public RequestOptionsBuilder setConnectionProxy(Proxy connectionProxy) {
            this.connectionProxy = connectionProxy;
            return this;
        }

        public PasswordAuthentication getProxyCredential() {
            return this.proxyCredential;
        }

        public RequestOptionsBuilder setProxyCredential(PasswordAuthentication proxyCredential) {
            this.proxyCredential = proxyCredential;
            return this;
        }

        public RequestOptionsBuilder clearIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }

        public String getStripeAccount() {
            return this.stripeAccount;
        }

        public RequestOptionsBuilder setStripeAccount(String stripeAccount) {
            this.stripeAccount = stripeAccount;
            return this;
        }

        public RequestOptionsBuilder clearStripeAccount() {
            return this.setStripeAccount(null);
        }

        public String getStripeVersionOverride() {
            return this.stripeVersionOverride;
        }

        public RequestOptionsBuilder setStripeVersionOverride(String stripeVersionOverride) {
            this.stripeVersionOverride = RequestOptions.normalizeStripeVersion(stripeVersionOverride);
            return this;
        }

        public RequestOptionsBuilder clearStripeVersionOverride() {
            return this.setStripeVersionOverride(null);
        }

        public RequestOptions build() {
            return new RequestOptions(RequestOptions.normalizeApiKey(this.apiKey), RequestOptions.normalizeClientId(this.clientId), RequestOptions.normalizeIdempotencyKey(this.idempotencyKey), RequestOptions.normalizeStripeAccount(this.stripeAccount), RequestOptions.normalizeStripeVersion(this.stripeVersionOverride), this.connectTimeout, this.readTimeout, this.maxNetworkRetries, this.connectionProxy, this.proxyCredential);
        }
    }
}

