/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.checkout;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SessionCreateParams
extends ApiRequestParams {
    @SerializedName(value="allow_promotion_codes")
    Boolean allowPromotionCodes;
    @SerializedName(value="billing_address_collection")
    BillingAddressCollection billingAddressCollection;
    @SerializedName(value="cancel_url")
    String cancelUrl;
    @SerializedName(value="client_reference_id")
    String clientReferenceId;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_email")
    String customerEmail;
    @SerializedName(value="discounts")
    List<Discount> discounts;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="line_items")
    List<LineItem> lineItems;
    @SerializedName(value="locale")
    Locale locale;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="mode")
    Mode mode;
    @SerializedName(value="payment_intent_data")
    PaymentIntentData paymentIntentData;
    @SerializedName(value="payment_method_types")
    List<PaymentMethodType> paymentMethodTypes;
    @SerializedName(value="setup_intent_data")
    SetupIntentData setupIntentData;
    @SerializedName(value="shipping_address_collection")
    ShippingAddressCollection shippingAddressCollection;
    @SerializedName(value="submit_type")
    SubmitType submitType;
    @SerializedName(value="subscription_data")
    SubscriptionData subscriptionData;
    @SerializedName(value="success_url")
    String successUrl;

    private SessionCreateParams(Boolean allowPromotionCodes, BillingAddressCollection billingAddressCollection, String cancelUrl, String clientReferenceId, String customer, String customerEmail, List<Discount> discounts, List<String> expand, Map<String, Object> extraParams, List<LineItem> lineItems, Locale locale, Map<String, String> metadata, Mode mode, PaymentIntentData paymentIntentData, List<PaymentMethodType> paymentMethodTypes, SetupIntentData setupIntentData, ShippingAddressCollection shippingAddressCollection, SubmitType submitType, SubscriptionData subscriptionData, String successUrl) {
        this.allowPromotionCodes = allowPromotionCodes;
        this.billingAddressCollection = billingAddressCollection;
        this.cancelUrl = cancelUrl;
        this.clientReferenceId = clientReferenceId;
        this.customer = customer;
        this.customerEmail = customerEmail;
        this.discounts = discounts;
        this.expand = expand;
        this.extraParams = extraParams;
        this.lineItems = lineItems;
        this.locale = locale;
        this.metadata = metadata;
        this.mode = mode;
        this.paymentIntentData = paymentIntentData;
        this.paymentMethodTypes = paymentMethodTypes;
        this.setupIntentData = setupIntentData;
        this.shippingAddressCollection = shippingAddressCollection;
        this.submitType = submitType;
        this.subscriptionData = subscriptionData;
        this.successUrl = successUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Boolean getAllowPromotionCodes() {
        return this.allowPromotionCodes;
    }

    @Generated
    public BillingAddressCollection getBillingAddressCollection() {
        return this.billingAddressCollection;
    }

    @Generated
    public String getCancelUrl() {
        return this.cancelUrl;
    }

    @Generated
    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public String getCustomerEmail() {
        return this.customerEmail;
    }

    @Generated
    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Mode getMode() {
        return this.mode;
    }

    @Generated
    public PaymentIntentData getPaymentIntentData() {
        return this.paymentIntentData;
    }

    @Generated
    public List<PaymentMethodType> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public SetupIntentData getSetupIntentData() {
        return this.setupIntentData;
    }

    @Generated
    public ShippingAddressCollection getShippingAddressCollection() {
        return this.shippingAddressCollection;
    }

    @Generated
    public SubmitType getSubmitType() {
        return this.submitType;
    }

    @Generated
    public SubscriptionData getSubscriptionData() {
        return this.subscriptionData;
    }

    @Generated
    public String getSuccessUrl() {
        return this.successUrl;
    }

    public static enum SubmitType implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        BOOK("book"),
        DONATE("donate"),
        PAY("pay");

        private final String value;

        private SubmitType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum PaymentMethodType implements ApiRequestParams.EnumParam
    {
        ALIPAY("alipay"),
        BACS_DEBIT("bacs_debit"),
        BANCONTACT("bancontact"),
        CARD("card"),
        EPS("eps"),
        FPX("fpx"),
        GIROPAY("giropay"),
        IDEAL("ideal"),
        P24("p24"),
        SEPA_DEBIT("sepa_debit"),
        SOFORT("sofort");

        private final String value;

        private PaymentMethodType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Mode implements ApiRequestParams.EnumParam
    {
        PAYMENT("payment"),
        SETUP("setup"),
        SUBSCRIPTION("subscription");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum Locale implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        BG("bg"),
        CS("cs"),
        DA("da"),
        DE("de"),
        EL("el"),
        EN("en"),
        EN_GB("en-GB"),
        ES("es"),
        ES_419("es-419"),
        ET("et"),
        FI("fi"),
        FR("fr"),
        FR_CA("fr-CA"),
        HU("hu"),
        ID("id"),
        IT("it"),
        JA("ja"),
        LT("lt"),
        LV("lv"),
        MS("ms"),
        MT("mt"),
        NB("nb"),
        NL("nl"),
        PL("pl"),
        PT("pt"),
        PT_BR("pt-BR"),
        RO("ro"),
        RU("ru"),
        SK("sk"),
        SL("sl"),
        SV("sv"),
        TR("tr"),
        ZH("zh"),
        ZH_HK("zh-HK"),
        ZH_TW("zh-TW");

        private final String value;

        private Locale(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum BillingAddressCollection implements ApiRequestParams.EnumParam
    {
        AUTO("auto"),
        REQUIRED("required");

        private final String value;

        private BillingAddressCollection(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class SubscriptionData {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="coupon")
        String coupon;
        @SerializedName(value="default_tax_rates")
        List<String> defaultTaxRates;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="items")
        List<Item> items;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="trial_end")
        Long trialEnd;
        @SerializedName(value="trial_from_plan")
        Boolean trialFromPlan;
        @SerializedName(value="trial_period_days")
        Long trialPeriodDays;

        private SubscriptionData(BigDecimal applicationFeePercent, String coupon, List<String> defaultTaxRates, Map<String, Object> extraParams, List<Item> items, Map<String, String> metadata, Long trialEnd, Boolean trialFromPlan, Long trialPeriodDays) {
            this.applicationFeePercent = applicationFeePercent;
            this.coupon = coupon;
            this.defaultTaxRates = defaultTaxRates;
            this.extraParams = extraParams;
            this.items = items;
            this.metadata = metadata;
            this.trialEnd = trialEnd;
            this.trialFromPlan = trialFromPlan;
            this.trialPeriodDays = trialPeriodDays;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public String getCoupon() {
            return this.coupon;
        }

        @Generated
        public List<String> getDefaultTaxRates() {
            return this.defaultTaxRates;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<Item> getItems() {
            return this.items;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public Boolean getTrialFromPlan() {
            return this.trialFromPlan;
        }

        @Generated
        public Long getTrialPeriodDays() {
            return this.trialPeriodDays;
        }

        public static class Item {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="plan")
            String plan;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_rates")
            List<String> taxRates;

            private Item(Map<String, Object> extraParams, String plan, Long quantity, List<String> taxRates) {
                this.extraParams = extraParams;
                this.plan = plan;
                this.quantity = quantity;
                this.taxRates = taxRates;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPlan() {
                return this.plan;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public List<String> getTaxRates() {
                return this.taxRates;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String plan;
                private Long quantity;
                private List<String> taxRates;

                public Item build() {
                    return new Item(this.extraParams, this.plan, this.quantity, this.taxRates);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPlan(String plan) {
                    this.plan = plan;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder addTaxRate(String element) {
                    if (this.taxRates == null) {
                        this.taxRates = new ArrayList<String>();
                    }
                    this.taxRates.add(element);
                    return this;
                }

                public Builder addAllTaxRate(List<String> elements) {
                    if (this.taxRates == null) {
                        this.taxRates = new ArrayList<String>();
                    }
                    this.taxRates.addAll(elements);
                    return this;
                }
            }
        }

        public static class Builder {
            private BigDecimal applicationFeePercent;
            private String coupon;
            private List<String> defaultTaxRates;
            private Map<String, Object> extraParams;
            private List<Item> items;
            private Map<String, String> metadata;
            private Long trialEnd;
            private Boolean trialFromPlan;
            private Long trialPeriodDays;

            public SubscriptionData build() {
                return new SubscriptionData(this.applicationFeePercent, this.coupon, this.defaultTaxRates, this.extraParams, this.items, this.metadata, this.trialEnd, this.trialFromPlan, this.trialPeriodDays);
            }

            public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
                this.applicationFeePercent = applicationFeePercent;
                return this;
            }

            public Builder setCoupon(String coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder addDefaultTaxRate(String element) {
                if (this.defaultTaxRates == null) {
                    this.defaultTaxRates = new ArrayList<String>();
                }
                this.defaultTaxRates.add(element);
                return this;
            }

            public Builder addAllDefaultTaxRate(List<String> elements) {
                if (this.defaultTaxRates == null) {
                    this.defaultTaxRates = new ArrayList<String>();
                }
                this.defaultTaxRates.addAll(elements);
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addItem(Item element) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.add(element);
                return this;
            }

            public Builder addAllItem(List<Item> elements) {
                if (this.items == null) {
                    this.items = new ArrayList<Item>();
                }
                this.items.addAll(elements);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setTrialEnd(Long trialEnd) {
                this.trialEnd = trialEnd;
                return this;
            }

            public Builder setTrialFromPlan(Boolean trialFromPlan) {
                this.trialFromPlan = trialFromPlan;
                return this;
            }

            public Builder setTrialPeriodDays(Long trialPeriodDays) {
                this.trialPeriodDays = trialPeriodDays;
                return this;
            }
        }
    }

    public static class ShippingAddressCollection {
        @SerializedName(value="allowed_countries")
        List<AllowedCountry> allowedCountries;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private ShippingAddressCollection(List<AllowedCountry> allowedCountries, Map<String, Object> extraParams) {
            this.allowedCountries = allowedCountries;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public List<AllowedCountry> getAllowedCountries() {
            return this.allowedCountries;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static enum AllowedCountry implements ApiRequestParams.EnumParam
        {
            AC("AC"),
            AD("AD"),
            AE("AE"),
            AF("AF"),
            AG("AG"),
            AI("AI"),
            AL("AL"),
            AM("AM"),
            AO("AO"),
            AQ("AQ"),
            AR("AR"),
            AT("AT"),
            AU("AU"),
            AW("AW"),
            AX("AX"),
            AZ("AZ"),
            BA("BA"),
            BB("BB"),
            BD("BD"),
            BE("BE"),
            BF("BF"),
            BG("BG"),
            BH("BH"),
            BI("BI"),
            BJ("BJ"),
            BL("BL"),
            BM("BM"),
            BN("BN"),
            BO("BO"),
            BQ("BQ"),
            BR("BR"),
            BS("BS"),
            BT("BT"),
            BV("BV"),
            BW("BW"),
            BY("BY"),
            BZ("BZ"),
            CA("CA"),
            CD("CD"),
            CF("CF"),
            CG("CG"),
            CH("CH"),
            CI("CI"),
            CK("CK"),
            CL("CL"),
            CM("CM"),
            CN("CN"),
            CO("CO"),
            CR("CR"),
            CV("CV"),
            CW("CW"),
            CY("CY"),
            CZ("CZ"),
            DE("DE"),
            DJ("DJ"),
            DK("DK"),
            DM("DM"),
            DO("DO"),
            DZ("DZ"),
            EC("EC"),
            EE("EE"),
            EG("EG"),
            EH("EH"),
            ER("ER"),
            ES("ES"),
            ET("ET"),
            FI("FI"),
            FJ("FJ"),
            FK("FK"),
            FO("FO"),
            FR("FR"),
            GA("GA"),
            GB("GB"),
            GD("GD"),
            GE("GE"),
            GF("GF"),
            GG("GG"),
            GH("GH"),
            GI("GI"),
            GL("GL"),
            GM("GM"),
            GN("GN"),
            GP("GP"),
            GQ("GQ"),
            GR("GR"),
            GS("GS"),
            GT("GT"),
            GU("GU"),
            GW("GW"),
            GY("GY"),
            HK("HK"),
            HN("HN"),
            HR("HR"),
            HT("HT"),
            HU("HU"),
            ID("ID"),
            IE("IE"),
            IL("IL"),
            IM("IM"),
            IN("IN"),
            IO("IO"),
            IQ("IQ"),
            IS("IS"),
            IT("IT"),
            JE("JE"),
            JM("JM"),
            JO("JO"),
            JP("JP"),
            KE("KE"),
            KG("KG"),
            KH("KH"),
            KI("KI"),
            KM("KM"),
            KN("KN"),
            KR("KR"),
            KW("KW"),
            KY("KY"),
            KZ("KZ"),
            LA("LA"),
            LB("LB"),
            LC("LC"),
            LI("LI"),
            LK("LK"),
            LR("LR"),
            LS("LS"),
            LT("LT"),
            LU("LU"),
            LV("LV"),
            LY("LY"),
            MA("MA"),
            MC("MC"),
            MD("MD"),
            ME("ME"),
            MF("MF"),
            MG("MG"),
            MK("MK"),
            ML("ML"),
            MM("MM"),
            MN("MN"),
            MO("MO"),
            MQ("MQ"),
            MR("MR"),
            MS("MS"),
            MT("MT"),
            MU("MU"),
            MV("MV"),
            MW("MW"),
            MX("MX"),
            MY("MY"),
            MZ("MZ"),
            NA("NA"),
            NC("NC"),
            NE("NE"),
            NG("NG"),
            NI("NI"),
            NL("NL"),
            NO("NO"),
            NP("NP"),
            NR("NR"),
            NU("NU"),
            NZ("NZ"),
            OM("OM"),
            PA("PA"),
            PE("PE"),
            PF("PF"),
            PG("PG"),
            PH("PH"),
            PK("PK"),
            PL("PL"),
            PM("PM"),
            PN("PN"),
            PR("PR"),
            PS("PS"),
            PT("PT"),
            PY("PY"),
            QA("QA"),
            RE("RE"),
            RO("RO"),
            RS("RS"),
            RU("RU"),
            RW("RW"),
            SA("SA"),
            SB("SB"),
            SC("SC"),
            SE("SE"),
            SG("SG"),
            SH("SH"),
            SI("SI"),
            SJ("SJ"),
            SK("SK"),
            SL("SL"),
            SM("SM"),
            SN("SN"),
            SO("SO"),
            SR("SR"),
            SS("SS"),
            ST("ST"),
            SV("SV"),
            SX("SX"),
            SZ("SZ"),
            TA("TA"),
            TC("TC"),
            TD("TD"),
            TF("TF"),
            TG("TG"),
            TH("TH"),
            TJ("TJ"),
            TK("TK"),
            TL("TL"),
            TM("TM"),
            TN("TN"),
            TO("TO"),
            TR("TR"),
            TT("TT"),
            TV("TV"),
            TW("TW"),
            TZ("TZ"),
            UA("UA"),
            UG("UG"),
            US("US"),
            UY("UY"),
            UZ("UZ"),
            VA("VA"),
            VC("VC"),
            VE("VE"),
            VG("VG"),
            VN("VN"),
            VU("VU"),
            WF("WF"),
            WS("WS"),
            XK("XK"),
            YE("YE"),
            YT("YT"),
            ZA("ZA"),
            ZM("ZM"),
            ZW("ZW"),
            ZZ("ZZ");

            private final String value;

            private AllowedCountry(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private List<AllowedCountry> allowedCountries;
            private Map<String, Object> extraParams;

            public ShippingAddressCollection build() {
                return new ShippingAddressCollection(this.allowedCountries, this.extraParams);
            }

            public Builder addAllowedCountry(AllowedCountry element) {
                if (this.allowedCountries == null) {
                    this.allowedCountries = new ArrayList<AllowedCountry>();
                }
                this.allowedCountries.add(element);
                return this;
            }

            public Builder addAllAllowedCountry(List<AllowedCountry> elements) {
                if (this.allowedCountries == null) {
                    this.allowedCountries = new ArrayList<AllowedCountry>();
                }
                this.allowedCountries.addAll(elements);
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class SetupIntentData {
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        String onBehalfOf;

        private SetupIntentData(String description, Map<String, Object> extraParams, Map<String, String> metadata, String onBehalfOf) {
            this.description = description;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.onBehalfOf = onBehalfOf;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getOnBehalfOf() {
            return this.onBehalfOf;
        }

        public static class Builder {
            private String description;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String onBehalfOf;

            public SetupIntentData build() {
                return new SetupIntentData(this.description, this.extraParams, this.metadata, this.onBehalfOf);
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }
        }
    }

    public static class PaymentIntentData {
        @SerializedName(value="application_fee_amount")
        Long applicationFeeAmount;
        @SerializedName(value="capture_method")
        CaptureMethod captureMethod;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        String onBehalfOf;
        @SerializedName(value="receipt_email")
        String receiptEmail;
        @SerializedName(value="setup_future_usage")
        SetupFutureUsage setupFutureUsage;
        @SerializedName(value="shipping")
        Shipping shipping;
        @SerializedName(value="statement_descriptor")
        String statementDescriptor;
        @SerializedName(value="statement_descriptor_suffix")
        String statementDescriptorSuffix;
        @SerializedName(value="transfer_data")
        TransferData transferData;
        @SerializedName(value="transfer_group")
        String transferGroup;

        private PaymentIntentData(Long applicationFeeAmount, CaptureMethod captureMethod, String description, Map<String, Object> extraParams, Map<String, String> metadata, String onBehalfOf, String receiptEmail, SetupFutureUsage setupFutureUsage, Shipping shipping, String statementDescriptor, String statementDescriptorSuffix, TransferData transferData, String transferGroup) {
            this.applicationFeeAmount = applicationFeeAmount;
            this.captureMethod = captureMethod;
            this.description = description;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.onBehalfOf = onBehalfOf;
            this.receiptEmail = receiptEmail;
            this.setupFutureUsage = setupFutureUsage;
            this.shipping = shipping;
            this.statementDescriptor = statementDescriptor;
            this.statementDescriptorSuffix = statementDescriptorSuffix;
            this.transferData = transferData;
            this.transferGroup = transferGroup;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getApplicationFeeAmount() {
            return this.applicationFeeAmount;
        }

        @Generated
        public CaptureMethod getCaptureMethod() {
            return this.captureMethod;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Generated
        public String getReceiptEmail() {
            return this.receiptEmail;
        }

        @Generated
        public SetupFutureUsage getSetupFutureUsage() {
            return this.setupFutureUsage;
        }

        @Generated
        public Shipping getShipping() {
            return this.shipping;
        }

        @Generated
        public String getStatementDescriptor() {
            return this.statementDescriptor;
        }

        @Generated
        public String getStatementDescriptorSuffix() {
            return this.statementDescriptorSuffix;
        }

        @Generated
        public TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public String getTransferGroup() {
            return this.transferGroup;
        }

        public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
        {
            OFF_SESSION("off_session"),
            ON_SESSION("on_session");

            private final String value;

            private SetupFutureUsage(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static enum CaptureMethod implements ApiRequestParams.EnumParam
        {
            AUTOMATIC("automatic"),
            MANUAL("manual");

            private final String value;

            private CaptureMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class TransferData {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="destination")
            String destination;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private TransferData(Long amount, String destination, Map<String, Object> extraParams) {
                this.amount = amount;
                this.destination = destination;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getDestination() {
                return this.destination;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            public static class Builder {
                private Long amount;
                private String destination;
                private Map<String, Object> extraParams;

                public TransferData build() {
                    return new TransferData(this.amount, this.destination, this.extraParams);
                }

                public Builder setAmount(Long amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder setDestination(String destination) {
                    this.destination = destination;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Shipping {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="carrier")
            String carrier;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;
            @SerializedName(value="tracking_number")
            String trackingNumber;

            private Shipping(Address address, String carrier, Map<String, Object> extraParams, String name, String phone, String trackingNumber) {
                this.address = address;
                this.carrier = carrier;
                this.extraParams = extraParams;
                this.name = name;
                this.phone = phone;
                this.trackingNumber = trackingNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getCarrier() {
                return this.carrier;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            @Generated
            public String getTrackingNumber() {
                return this.trackingNumber;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Address address;
                private String carrier;
                private Map<String, Object> extraParams;
                private String name;
                private String phone;
                private String trackingNumber;

                public Shipping build() {
                    return new Shipping(this.address, this.carrier, this.extraParams, this.name, this.phone, this.trackingNumber);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setCarrier(String carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setPhone(String phone) {
                    this.phone = phone;
                    return this;
                }

                public Builder setTrackingNumber(String trackingNumber) {
                    this.trackingNumber = trackingNumber;
                    return this;
                }
            }
        }

        public static class Builder {
            private Long applicationFeeAmount;
            private CaptureMethod captureMethod;
            private String description;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String onBehalfOf;
            private String receiptEmail;
            private SetupFutureUsage setupFutureUsage;
            private Shipping shipping;
            private String statementDescriptor;
            private String statementDescriptorSuffix;
            private TransferData transferData;
            private String transferGroup;

            public PaymentIntentData build() {
                return new PaymentIntentData(this.applicationFeeAmount, this.captureMethod, this.description, this.extraParams, this.metadata, this.onBehalfOf, this.receiptEmail, this.setupFutureUsage, this.shipping, this.statementDescriptor, this.statementDescriptorSuffix, this.transferData, this.transferGroup);
            }

            public Builder setApplicationFeeAmount(Long applicationFeeAmount) {
                this.applicationFeeAmount = applicationFeeAmount;
                return this;
            }

            public Builder setCaptureMethod(CaptureMethod captureMethod) {
                this.captureMethod = captureMethod;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setOnBehalfOf(String onBehalfOf) {
                this.onBehalfOf = onBehalfOf;
                return this;
            }

            public Builder setReceiptEmail(String receiptEmail) {
                this.receiptEmail = receiptEmail;
                return this;
            }

            public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                this.setupFutureUsage = setupFutureUsage;
                return this;
            }

            public Builder setShipping(Shipping shipping) {
                this.shipping = shipping;
                return this;
            }

            public Builder setStatementDescriptor(String statementDescriptor) {
                this.statementDescriptor = statementDescriptor;
                return this;
            }

            public Builder setStatementDescriptorSuffix(String statementDescriptorSuffix) {
                this.statementDescriptorSuffix = statementDescriptorSuffix;
                return this;
            }

            public Builder setTransferData(TransferData transferData) {
                this.transferData = transferData;
                return this;
            }

            public Builder setTransferGroup(String transferGroup) {
                this.transferGroup = transferGroup;
                return this;
            }
        }
    }

    public static class LineItem {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="images")
        List<String> images;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="price")
        String price;
        @SerializedName(value="price_data")
        PriceData priceData;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        List<String> taxRates;

        private LineItem(Long amount, String currency, String description, Map<String, Object> extraParams, List<String> images, String name, String price, PriceData priceData, Long quantity, List<String> taxRates) {
            this.amount = amount;
            this.currency = currency;
            this.description = description;
            this.extraParams = extraParams;
            this.images = images;
            this.name = name;
            this.price = price;
            this.priceData = priceData;
            this.quantity = quantity;
            this.taxRates = taxRates;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<String> getImages() {
            return this.images;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPrice() {
            return this.price;
        }

        @Generated
        public PriceData getPriceData() {
            return this.priceData;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public List<String> getTaxRates() {
            return this.taxRates;
        }

        public static class PriceData {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="product")
            String product;
            @SerializedName(value="product_data")
            ProductData productData;
            @SerializedName(value="recurring")
            Recurring recurring;
            @SerializedName(value="unit_amount")
            Long unitAmount;
            @SerializedName(value="unit_amount_decimal")
            BigDecimal unitAmountDecimal;

            private PriceData(String currency, Map<String, Object> extraParams, String product, ProductData productData, Recurring recurring, Long unitAmount, BigDecimal unitAmountDecimal) {
                this.currency = currency;
                this.extraParams = extraParams;
                this.product = product;
                this.productData = productData;
                this.recurring = recurring;
                this.unitAmount = unitAmount;
                this.unitAmountDecimal = unitAmountDecimal;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getProduct() {
                return this.product;
            }

            @Generated
            public ProductData getProductData() {
                return this.productData;
            }

            @Generated
            public Recurring getRecurring() {
                return this.recurring;
            }

            @Generated
            public Long getUnitAmount() {
                return this.unitAmount;
            }

            @Generated
            public BigDecimal getUnitAmountDecimal() {
                return this.unitAmountDecimal;
            }

            public static class Recurring {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                private Recurring(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;

                    public Recurring build() {
                        return new Recurring(this.extraParams, this.interval, this.intervalCount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }
                }
            }

            public static class ProductData {
                @SerializedName(value="description")
                String description;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="images")
                List<String> images;
                @SerializedName(value="metadata")
                Map<String, String> metadata;
                @SerializedName(value="name")
                String name;

                private ProductData(String description, Map<String, Object> extraParams, List<String> images, Map<String, String> metadata, String name) {
                    this.description = description;
                    this.extraParams = extraParams;
                    this.images = images;
                    this.metadata = metadata;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getDescription() {
                    return this.description;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public List<String> getImages() {
                    return this.images;
                }

                @Generated
                public Map<String, String> getMetadata() {
                    return this.metadata;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                public static class Builder {
                    private String description;
                    private Map<String, Object> extraParams;
                    private List<String> images;
                    private Map<String, String> metadata;
                    private String name;

                    public ProductData build() {
                        return new ProductData(this.description, this.extraParams, this.images, this.metadata, this.name);
                    }

                    public Builder setDescription(String description) {
                        this.description = description;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder addImage(String element) {
                        if (this.images == null) {
                            this.images = new ArrayList<String>();
                        }
                        this.images.add(element);
                        return this;
                    }

                    public Builder addAllImage(List<String> elements) {
                        if (this.images == null) {
                            this.images = new ArrayList<String>();
                        }
                        this.images.addAll(elements);
                        return this;
                    }

                    public Builder putMetadata(String key, String value) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.put(key, value);
                        return this;
                    }

                    public Builder putAllMetadata(Map<String, String> map) {
                        if (this.metadata == null) {
                            this.metadata = new HashMap<String, String>();
                        }
                        this.metadata.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Builder {
                private String currency;
                private Map<String, Object> extraParams;
                private String product;
                private ProductData productData;
                private Recurring recurring;
                private Long unitAmount;
                private BigDecimal unitAmountDecimal;

                public PriceData build() {
                    return new PriceData(this.currency, this.extraParams, this.product, this.productData, this.recurring, this.unitAmount, this.unitAmountDecimal);
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setProduct(String product) {
                    this.product = product;
                    return this;
                }

                public Builder setProductData(ProductData productData) {
                    this.productData = productData;
                    return this;
                }

                public Builder setRecurring(Recurring recurring) {
                    this.recurring = recurring;
                    return this;
                }

                public Builder setUnitAmount(Long unitAmount) {
                    this.unitAmount = unitAmount;
                    return this;
                }

                public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                    this.unitAmountDecimal = unitAmountDecimal;
                    return this;
                }
            }
        }

        public static class Builder {
            private Long amount;
            private String currency;
            private String description;
            private Map<String, Object> extraParams;
            private List<String> images;
            private String name;
            private String price;
            private PriceData priceData;
            private Long quantity;
            private List<String> taxRates;

            public LineItem build() {
                return new LineItem(this.amount, this.currency, this.description, this.extraParams, this.images, this.name, this.price, this.priceData, this.quantity, this.taxRates);
            }

            public Builder setAmount(Long amount) {
                this.amount = amount;
                return this;
            }

            public Builder setCurrency(String currency) {
                this.currency = currency;
                return this;
            }

            public Builder setDescription(String description) {
                this.description = description;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addImage(String element) {
                if (this.images == null) {
                    this.images = new ArrayList<String>();
                }
                this.images.add(element);
                return this;
            }

            public Builder addAllImage(List<String> elements) {
                if (this.images == null) {
                    this.images = new ArrayList<String>();
                }
                this.images.addAll(elements);
                return this;
            }

            public Builder setName(String name) {
                this.name = name;
                return this;
            }

            public Builder setPrice(String price) {
                this.price = price;
                return this;
            }

            public Builder setPriceData(PriceData priceData) {
                this.priceData = priceData;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder addTaxRate(String element) {
                if (this.taxRates == null) {
                    this.taxRates = new ArrayList<String>();
                }
                this.taxRates.add(element);
                return this;
            }

            public Builder addAllTaxRate(List<String> elements) {
                if (this.taxRates == null) {
                    this.taxRates = new ArrayList<String>();
                }
                this.taxRates.addAll(elements);
                return this;
            }
        }
    }

    public static class Discount {
        @SerializedName(value="coupon")
        String coupon;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="promotion_code")
        String promotionCode;

        private Discount(String coupon, Map<String, Object> extraParams, String promotionCode) {
            this.coupon = coupon;
            this.extraParams = extraParams;
            this.promotionCode = promotionCode;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public String getCoupon() {
            return this.coupon;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getPromotionCode() {
            return this.promotionCode;
        }

        public static class Builder {
            private String coupon;
            private Map<String, Object> extraParams;
            private String promotionCode;

            public Discount build() {
                return new Discount(this.coupon, this.extraParams, this.promotionCode);
            }

            public Builder setCoupon(String coupon) {
                this.coupon = coupon;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPromotionCode(String promotionCode) {
                this.promotionCode = promotionCode;
                return this;
            }
        }
    }

    public static class Builder {
        private Boolean allowPromotionCodes;
        private BillingAddressCollection billingAddressCollection;
        private String cancelUrl;
        private String clientReferenceId;
        private String customer;
        private String customerEmail;
        private List<Discount> discounts;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private List<LineItem> lineItems;
        private Locale locale;
        private Map<String, String> metadata;
        private Mode mode;
        private PaymentIntentData paymentIntentData;
        private List<PaymentMethodType> paymentMethodTypes;
        private SetupIntentData setupIntentData;
        private ShippingAddressCollection shippingAddressCollection;
        private SubmitType submitType;
        private SubscriptionData subscriptionData;
        private String successUrl;

        public SessionCreateParams build() {
            return new SessionCreateParams(this.allowPromotionCodes, this.billingAddressCollection, this.cancelUrl, this.clientReferenceId, this.customer, this.customerEmail, this.discounts, this.expand, this.extraParams, this.lineItems, this.locale, this.metadata, this.mode, this.paymentIntentData, this.paymentMethodTypes, this.setupIntentData, this.shippingAddressCollection, this.submitType, this.subscriptionData, this.successUrl);
        }

        public Builder setAllowPromotionCodes(Boolean allowPromotionCodes) {
            this.allowPromotionCodes = allowPromotionCodes;
            return this;
        }

        public Builder setBillingAddressCollection(BillingAddressCollection billingAddressCollection) {
            this.billingAddressCollection = billingAddressCollection;
            return this;
        }

        public Builder setCancelUrl(String cancelUrl) {
            this.cancelUrl = cancelUrl;
            return this;
        }

        public Builder setClientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerEmail(String customerEmail) {
            this.customerEmail = customerEmail;
            return this;
        }

        public Builder addDiscount(Discount element) {
            if (this.discounts == null) {
                this.discounts = new ArrayList<Discount>();
            }
            this.discounts.add(element);
            return this;
        }

        public Builder addAllDiscount(List<Discount> elements) {
            if (this.discounts == null) {
                this.discounts = new ArrayList<Discount>();
            }
            this.discounts.addAll(elements);
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder addLineItem(LineItem element) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.add(element);
            return this;
        }

        public Builder addAllLineItem(List<LineItem> elements) {
            if (this.lineItems == null) {
                this.lineItems = new ArrayList<LineItem>();
            }
            this.lineItems.addAll(elements);
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.putAll(map);
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setPaymentIntentData(PaymentIntentData paymentIntentData) {
            this.paymentIntentData = paymentIntentData;
            return this;
        }

        public Builder addPaymentMethodType(PaymentMethodType element) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<PaymentMethodType>();
            }
            this.paymentMethodTypes.add(element);
            return this;
        }

        public Builder addAllPaymentMethodType(List<PaymentMethodType> elements) {
            if (this.paymentMethodTypes == null) {
                this.paymentMethodTypes = new ArrayList<PaymentMethodType>();
            }
            this.paymentMethodTypes.addAll(elements);
            return this;
        }

        public Builder setSetupIntentData(SetupIntentData setupIntentData) {
            this.setupIntentData = setupIntentData;
            return this;
        }

        public Builder setShippingAddressCollection(ShippingAddressCollection shippingAddressCollection) {
            this.shippingAddressCollection = shippingAddressCollection;
            return this;
        }

        public Builder setSubmitType(SubmitType submitType) {
            this.submitType = submitType;
            return this;
        }

        public Builder setSubscriptionData(SubscriptionData subscriptionData) {
            this.subscriptionData = subscriptionData;
            return this;
        }

        public Builder setSuccessUrl(String successUrl) {
            this.successUrl = successUrl;
            return this;
        }
    }
}

