/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import com.structurizr.model.Element;
import com.structurizr.model.Relationship;
import com.structurizr.util.StringUtils;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ElementView;
import com.structurizr.view.LayoutMergeStrategy;
import com.structurizr.view.RelationshipView;
import com.structurizr.view.View;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultLayoutMergeStrategy
implements LayoutMergeStrategy {
    private static final Log log = LogFactory.getLog(View.class);

    @Override
    public void copyLayoutInformation(@Nonnull View viewWithLayoutInformation, @Nonnull View viewWithoutLayoutInformation) {
        ElementView elementViewWithLayoutInformation;
        this.setPaperSizeIfNotSpecified(viewWithLayoutInformation, viewWithoutLayoutInformation);
        this.setDimensionsIfNotSpecified(viewWithLayoutInformation, viewWithoutLayoutInformation);
        HashMap<ElementView, ElementView> elementViewMap = new HashMap<ElementView, ElementView>();
        HashMap<Element, Element> elementMap = new HashMap<Element, Element>();
        for (ElementView elementViewWithoutLayoutInformation : viewWithoutLayoutInformation.getElements()) {
            elementViewWithLayoutInformation = this.findElementView(viewWithLayoutInformation, elementViewWithoutLayoutInformation.getElement());
            if (elementViewWithLayoutInformation != null) {
                elementViewMap.put(elementViewWithoutLayoutInformation, elementViewWithLayoutInformation);
                elementMap.put(elementViewWithoutLayoutInformation.getElement(), elementViewWithLayoutInformation.getElement());
                continue;
            }
            log.warn((Object)("There is no layout information for the element named " + elementViewWithoutLayoutInformation.getElement().getName() + " on view " + viewWithLayoutInformation.getKey()));
        }
        for (ElementView elementViewWithoutLayoutInformation : elementViewMap.keySet()) {
            elementViewWithLayoutInformation = (ElementView)elementViewMap.get(elementViewWithoutLayoutInformation);
            elementViewWithoutLayoutInformation.copyLayoutInformationFrom(elementViewWithLayoutInformation);
        }
        for (RelationshipView relationshipViewWithoutLayoutInformation : viewWithoutLayoutInformation.getRelationships()) {
            RelationshipView relationshipViewWithLayoutInformation = viewWithoutLayoutInformation instanceof DynamicView ? this.findRelationshipView(viewWithLayoutInformation, relationshipViewWithoutLayoutInformation, elementMap) : this.findRelationshipView(viewWithLayoutInformation, relationshipViewWithoutLayoutInformation.getRelationship(), elementMap);
            if (relationshipViewWithLayoutInformation == null) continue;
            relationshipViewWithoutLayoutInformation.copyLayoutInformationFrom(relationshipViewWithLayoutInformation);
        }
    }

    private void setPaperSizeIfNotSpecified(@Nonnull View remoteView, @Nonnull View localView) {
        if (localView.getPaperSize() == null) {
            localView.setPaperSize(remoteView.getPaperSize());
        }
    }

    private void setDimensionsIfNotSpecified(@Nonnull View remoteView, @Nonnull View localView) {
        if (localView.getDimensions() == null) {
            localView.setDimensions(remoteView.getDimensions());
        }
    }

    protected ElementView findElementView(View viewWithLayoutInformation, Element elementWithoutLayoutInformation) {
        ElementView elementView = viewWithLayoutInformation.getElements().stream().filter(ev -> ev.getElement().getCanonicalName().equals(elementWithoutLayoutInformation.getCanonicalName())).findFirst().orElse(null);
        if (elementView == null) {
            elementView = viewWithLayoutInformation.getElements().stream().filter(ev -> ev.getElement().getName().equals(elementWithoutLayoutInformation.getName()) && ev.getElement().getClass().equals(elementWithoutLayoutInformation.getClass())).findFirst().orElse(null);
        }
        if (elementView == null && !StringUtils.isNullOrEmpty(elementWithoutLayoutInformation.getDescription())) {
            elementView = viewWithLayoutInformation.getElements().stream().filter(ev -> elementWithoutLayoutInformation.getDescription().equals(ev.getElement().getDescription()) && ev.getElement().getClass().equals(elementWithoutLayoutInformation.getClass())).findFirst().orElse(null);
        }
        if (elementView == null) {
            elementView = viewWithLayoutInformation.getElements().stream().filter(ev -> ev.getElement().getId().equals(elementWithoutLayoutInformation.getId()) && ev.getElement().getClass().equals(elementWithoutLayoutInformation.getClass())).findFirst().orElse(null);
        }
        return elementView;
    }

    private RelationshipView findRelationshipView(View viewWithLayoutInformation, Relationship relationshipWithoutLayoutInformation, Map<Element, Element> elementMap) {
        if (!elementMap.containsKey(relationshipWithoutLayoutInformation.getSource()) || !elementMap.containsKey(relationshipWithoutLayoutInformation.getDestination())) {
            return null;
        }
        Element sourceElementWithLayoutInformation = elementMap.get(relationshipWithoutLayoutInformation.getSource());
        Element destinationElementWithLayoutInformation = elementMap.get(relationshipWithoutLayoutInformation.getDestination());
        for (RelationshipView rv : viewWithLayoutInformation.getRelationships()) {
            if (!rv.getRelationship().getSource().equals(sourceElementWithLayoutInformation) || !rv.getRelationship().getDestination().equals(destinationElementWithLayoutInformation) || !rv.getRelationship().getDescription().equals(relationshipWithoutLayoutInformation.getDescription())) continue;
            return rv;
        }
        for (RelationshipView rv : viewWithLayoutInformation.getRelationships()) {
            if (!rv.getRelationship().getSource().equals(sourceElementWithLayoutInformation) || !rv.getRelationship().getDestination().equals(destinationElementWithLayoutInformation) || !rv.getRelationship().getId().equals(relationshipWithoutLayoutInformation.getId())) continue;
            return rv;
        }
        return null;
    }

    private RelationshipView findRelationshipView(View view, RelationshipView relationshipWithoutLayoutInformation, Map<Element, Element> elementMap) {
        if (!elementMap.containsKey(relationshipWithoutLayoutInformation.getRelationship().getSource()) || !elementMap.containsKey(relationshipWithoutLayoutInformation.getRelationship().getDestination())) {
            return null;
        }
        Element sourceElementWithLayoutInformation = elementMap.get(relationshipWithoutLayoutInformation.getRelationship().getSource());
        Element destinationElementWithLayoutInformation = elementMap.get(relationshipWithoutLayoutInformation.getRelationship().getDestination());
        for (RelationshipView rv : view.getRelationships()) {
            if (!rv.getRelationship().getSource().equals(sourceElementWithLayoutInformation) || !rv.getRelationship().getDestination().equals(destinationElementWithLayoutInformation) || !rv.getDescription().equals(relationshipWithoutLayoutInformation.getDescription()) || !rv.getOrder().equals(relationshipWithoutLayoutInformation.getOrder())) continue;
            return rv;
        }
        for (RelationshipView rv : view.getRelationships()) {
            if (!rv.getRelationship().getSource().equals(sourceElementWithLayoutInformation) || !rv.getRelationship().getDestination().equals(destinationElementWithLayoutInformation) || !rv.getRelationship().getId().equals(relationshipWithoutLayoutInformation.getId()) || !rv.getOrder().equals(relationshipWithoutLayoutInformation.getOrder())) continue;
            return rv;
        }
        return null;
    }
}

