/*
 * Decompiled with CFR 0.152.
 */
package struqt.util;

import struqt.util.UniqueIdCodec;

public class UniqueId {
    private static final UniqueIdCodec CODEC = new UniqueIdCodec(43L, 9L);
    private final long value;
    private final long instance;
    private final long timestamp;
    private final long sequence;

    public static UniqueId valueOf(long timeMillis, long instance, long sequence) {
        return UniqueId.decode(UniqueId.encode(timeMillis, instance, sequence));
    }

    public static UniqueId valueOf(long id) {
        return UniqueId.getCodec().decode(id);
    }

    public static UniqueId decode(long id) {
        return UniqueId.getCodec().decode(id);
    }

    public static long encode(long timeMillis, long instance, long sequence) {
        return UniqueId.getCodec().encode(timeMillis, instance, sequence);
    }

    public static UniqueIdCodec getCodec() {
        return CODEC;
    }

    UniqueId(long timestamp, long instance, long sequence) {
        this.value = CODEC.encode(timestamp, instance, sequence);
        this.timestamp = CODEC.getTimestamp(this.value);
        this.instance = CODEC.getInstance(this.value);
        this.sequence = CODEC.getSequence(this.value);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getInstance() {
        return this.instance;
    }

    public long getSequence() {
        return this.sequence;
    }

    public long getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniqueId)) {
            return false;
        }
        UniqueId uniqueId = (UniqueId)o;
        return this.getValue() == uniqueId.getValue();
    }

    public int hashCode() {
        return Long.valueOf(this.getValue()).hashCode();
    }

    public String toString() {
        return "UniqueId{value=" + this.value + ", instance=" + this.instance + ", timestamp=" + this.timestamp + ", sequence=" + this.sequence + '}';
    }
}

