/*
 * Decompiled with CFR 0.152.
 */
package struqt.util;

import struqt.util.UniqueId;

public final class UniqueIdCodec {
    private final long instanceShift;
    private final long instanceMask;
    private final long instanceMax;
    private final long timestampShift;
    private final long timestampMask;
    private final long timestampMax;
    private final long sequenceMask;
    private final long sequenceMax;

    public UniqueIdCodec(long timestampBits, long instanceBits) {
        if (timestampBits <= 0L || instanceBits <= 0L) {
            throw new IllegalArgumentException("Arguments 'timestampBits' and 'instanceBits' must be greater than 0");
        }
        long totalBits = 63L;
        long sequenceBits = totalBits - timestampBits - instanceBits;
        if (sequenceBits <= 0L) {
            throw new IllegalArgumentException("Sum of 'timestampBits' and 'instanceBits' must be less than " + totalBits);
        }
        this.instanceShift = sequenceBits;
        this.timestampShift = sequenceBits + instanceBits;
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)sequenceBits;
        this.instanceMask = (0xFFFFFFFFFFFFFFFFL ^ -1L << (int)instanceBits) << (int)this.instanceShift;
        this.timestampMask = (0xFFFFFFFFFFFFFFFFL ^ -1L << (int)timestampBits) << (int)this.timestampShift;
        this.timestampMax = (1L << (int)timestampBits) - 1L;
        this.instanceMax = (1L << (int)instanceBits) - 1L;
        this.sequenceMax = (1L << (int)sequenceBits) - 1L;
    }

    public long encode(long timestamp, long instance, long sequence) {
        return timestamp << (int)this.timestampShift & this.timestampMask | instance << (int)this.instanceShift & this.instanceMask | sequence & this.sequenceMask;
    }

    public UniqueId decode(long id) {
        return new UniqueId(this.getTimestamp(id), this.getInstance(id), this.getSequence(id));
    }

    public long getTimestamp(long id) {
        return (id & this.timestampMask) >> (int)this.timestampShift;
    }

    public long getInstance(long id) {
        return (id & this.instanceMask) >> (int)this.instanceShift;
    }

    public long getSequence(long id) {
        return id & this.sequenceMask;
    }

    public long getTimestampMax() {
        return this.timestampMax;
    }

    public long getInstanceMax() {
        return this.instanceMax;
    }

    public long getSequenceMax() {
        return this.sequenceMax;
    }
}

