/*
 * Decompiled with CFR 0.152.
 */
package struqt.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import struqt.util.TimeReversalException;
import struqt.util.UniqueId;
import struqt.util.UniqueIdCodec;

public class UniqueIdGenerator {
    private final UniqueIdCodec codec;
    private final long instance;
    private final long sequenceMax;
    private final Lock lock;
    private long count;
    private long timeMillis;

    public UniqueIdGenerator(long instanceId) {
        this(instanceId, null);
    }

    public UniqueIdGenerator(long instanceId, UniqueIdCodec codec) {
        this.codec = codec == null ? UniqueId.getCodec() : codec;
        this.instance = instanceId;
        this.sequenceMax = this.codec.getSequenceMax();
        this.lock = new ReentrantLock();
        this.count = 0L;
        this.timeMillis = this.systemTimeMillis();
    }

    public final long next() {
        long id;
        try {
            this.lock.lock();
            id = this.nextId();
        }
        finally {
            this.lock.unlock();
        }
        return id;
    }

    private long nextId() {
        long index;
        if ((index = this.sequenceMax & this.count++) == 0L) {
            this.updateTime();
        }
        return this.codec.encode(this.timeMillis, this.instance, index);
    }

    private void updateTime() {
        long prev = this.timeMillis;
        long now = this.systemTimeMillis();
        if (now > prev) {
            this.timeMillis = now;
        } else if (now == prev) {
            while (now <= prev) {
                now = this.systemTimeMillis();
            }
            this.timeMillis = now;
        } else {
            throw new TimeReversalException();
        }
    }

    protected long systemTimeMillis() {
        return System.currentTimeMillis();
    }
}

