/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.agent;

import com.sun.btrace.agent.Main;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class TraceOutputWriter
extends Writer {
    public static TraceOutputWriter fileWriter(File output) {
        SimpleFileOutput instance = null;
        try {
            instance = new SimpleFileOutput(output);
        }
        catch (IOException e) {
            Main.debugPrint(e);
        }
        return instance;
    }

    public static TraceOutputWriter rollingFileWriter(File output, long interval, TimeUnit unit) {
        TimeBasedRollingFileWriter instance = null;
        try {
            instance = new TimeBasedRollingFileWriter(null, interval, unit);
        }
        catch (IOException e) {
            Main.debugPrint(e);
        }
        return instance;
    }

    public static TraceOutputWriter rollingFileWriter(File output, int maxRolls, long interval, TimeUnit unit) {
        TimeBasedRollingFileWriter instance = null;
        try {
            instance = new TimeBasedRollingFileWriter(output, maxRolls, interval, unit);
        }
        catch (IOException e) {
            Main.debugPrint(e);
        }
        return instance;
    }

    private static void ensurePathExists(File f) {
        if (f == null || f.exists()) {
            return;
        }
        TraceOutputWriter.ensurePathExists(f.getParentFile());
        System.err.println("continuing");
        if (!f.getName().endsWith(".btrace")) {
            try {
                System.err.println("creating new folder " + f.toString());
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static abstract class RollingFileWriter
    extends TraceOutputWriter {
        private final ReentrantReadWriteLock writerLock = new ReentrantReadWriteLock();
        private FileWriter currentFileWriter;
        private String path;
        private String baseName;
        private int counter = 1;
        private int maxRolls;

        public RollingFileWriter(File output) throws IOException {
            this(output, 5);
        }

        public RollingFileWriter(File output, int maxRolls) throws IOException {
            output.getParentFile().mkdirs();
            this.currentFileWriter = new FileWriter(output);
            this.path = output.getParentFile().getAbsolutePath();
            this.baseName = output.getName();
            this.maxRolls = maxRolls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void close() throws IOException {
            try {
                this.writerLock.readLock().lock();
                this.currentFileWriter.close();
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void flush() throws IOException {
            try {
                this.writerLock.readLock().lock();
                this.currentFileWriter.flush();
            }
            finally {
                this.writerLock.readLock().unlock();
            }
            if (this.needsRoll()) {
                this.nextWriter();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this.writerLock.readLock().lock();
                this.currentFileWriter.write(cbuf, off, len);
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nextWriter() {
            try {
                this.writerLock.writeLock().lock();
                this.currentFileWriter = this.getNextWriter();
            }
            catch (IOException e) {
                Main.debugPrint(e);
            }
            finally {
                this.writerLock.writeLock().unlock();
            }
        }

        private FileWriter getNextWriter() throws IOException {
            this.currentFileWriter.close();
            File scriptOutputFile_renameFrom = new File(this.path + File.separator + this.baseName);
            File scriptOutputFile_renameTo = new File(this.path + File.separator + this.baseName + "." + this.counter++);
            if (scriptOutputFile_renameTo.exists()) {
                scriptOutputFile_renameTo.delete();
            }
            scriptOutputFile_renameFrom.renameTo(scriptOutputFile_renameTo);
            scriptOutputFile_renameFrom = new File(this.path + File.separator + this.baseName);
            if (this.counter > this.maxRolls) {
                this.counter = 1;
            }
            return new FileWriter(scriptOutputFile_renameFrom);
        }

        protected abstract boolean needsRoll();
    }

    private static class SimpleFileOutput
    extends TraceOutputWriter {
        private final FileWriter delegate;

        public SimpleFileOutput(File output) throws IOException {
            output.getParentFile().mkdirs();
            this.delegate = new FileWriter(output);
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.delegate.write(cbuf, off, len);
        }
    }

    private static class TimeBasedRollingFileWriter
    extends RollingFileWriter {
        private long lastTimeStamp = System.currentTimeMillis();
        private long interval;
        private TimeUnit unit;

        public TimeBasedRollingFileWriter(File output, int maxRolls, long interval, TimeUnit unit) throws IOException {
            super(output, maxRolls);
            this.interval = interval;
            this.unit = unit;
        }

        public TimeBasedRollingFileWriter(File output, long interval, TimeUnit unit) throws IOException {
            super(output);
            this.interval = interval;
            this.unit = unit;
        }

        @Override
        protected boolean needsRoll() {
            long currTime = System.currentTimeMillis();
            long myInterval = currTime - this.lastTimeStamp;
            if (this.unit.convert(myInterval, TimeUnit.MILLISECONDS) >= this.interval) {
                this.lastTimeStamp = currTime;
                return true;
            }
            return false;
        }
    }
}

