/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.profiling;

import com.sun.btrace.Profiler;
import java.util.HashMap;
import java.util.Map;

public class MethodInvocationProfiler
extends Profiler
implements Profiler.MBeanValueProvider {
    private final Map<Thread, MethodInvocationRecorder> recorders = new HashMap<Thread, MethodInvocationRecorder>(128);
    private volatile Profiler.Snapshot lastValidSnapshot = null;
    private int expectedBlockCnt;
    private long lastTs = this.START_TIME;

    public MethodInvocationProfiler(int expectedMethodCnt) {
        this.expectedBlockCnt = expectedMethodCnt;
    }

    public void recordEntry(String blockName) {
        this.getThreadSampler().recordEntry(blockName);
    }

    public void recordExit(String blockName, long duration) {
        this.getThreadSampler().recordExit(blockName, duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<Thread, MethodInvocationRecorder> map = this.recorders;
        synchronized (map) {
            for (MethodInvocationRecorder r : this.recorders.values()) {
                r.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler.Snapshot snapshot(boolean reset) {
        Map<Thread, MethodInvocationRecorder> map = this.recorders;
        synchronized (map) {
            HashMap<String, Integer> idMap = new HashMap<String, Integer>();
            Profiler.Record[] mergedRecords = null;
            int mergedEntries = 0;
            int mergedCapacity = 0;
            for (Map.Entry<Thread, MethodInvocationRecorder> sEntry : this.recorders.entrySet()) {
                int i;
                Profiler.Record[] records = sEntry.getValue().getRecords(reset);
                if (records == null || records.length == 0) continue;
                if (mergedRecords == null) {
                    mergedRecords = records;
                    mergedCapacity = mergedRecords.length;
                    for (i = 0; i < records.length; ++i) {
                        if (records[i] != null) {
                            mergedEntries = i + 1;
                        }
                        idMap.put(records[i].blockName, i);
                    }
                    continue;
                }
                for (i = 0; i < records.length; ++i) {
                    Profiler.Record r = records[i];
                    Integer id = (Integer)idMap.get(r.blockName);
                    if (id == null) {
                        id = mergedEntries++;
                        if (mergedEntries > mergedCapacity) {
                            mergedCapacity = (int)((double)(mergedEntries + 1) * 1.25);
                            Profiler.Record[] newRecs = new Profiler.Record[mergedCapacity];
                            System.arraycopy(mergedRecords, 0, newRecs, 0, mergedEntries - 1);
                            mergedRecords = newRecs;
                        }
                        idMap.put(r.blockName, id);
                        mergedRecords[id.intValue()] = r;
                        continue;
                    }
                    Profiler.Record merged = mergedRecords[id];
                    merged.invocations += r.invocations;
                    merged.selfTime += r.selfTime;
                    merged.wallTime += r.wallTime;
                }
            }
            Profiler.Record[] rslt = new Profiler.Record[mergedEntries];
            if (mergedRecords != null) {
                System.arraycopy(mergedRecords, 0, rslt, 0, mergedEntries);
            }
            long curTs = System.currentTimeMillis();
            Profiler.Snapshot snp = new Profiler.Snapshot(rslt, this.lastTs, curTs);
            this.lastTs = curTs;
            this.lastValidSnapshot = snp;
            return snp;
        }
    }

    public Profiler.Snapshot getMBeanValue() {
        return this.lastValidSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodInvocationRecorder getThreadSampler() {
        Thread t = Thread.currentThread();
        MethodInvocationRecorder s = this.recorders.get(t);
        if (s == null) {
            Map<Thread, MethodInvocationRecorder> map = this.recorders;
            synchronized (map) {
                if (!this.recorders.containsKey(t)) {
                    s = new MethodInvocationRecorder(this.expectedBlockCnt);
                    this.recorders.put(t, s);
                }
            }
        }
        return s;
    }

    private static class MethodInvocationRecorder {
        private int stackSize = 200;
        private int stackPtr = -1;
        private int stackBndr = 150;
        private Profiler.Record[] stackArr = new Profiler.Record[this.stackSize];
        private int measuredSize = 0;
        private int measuredPtr = 0;
        private Profiler.Record[] measured = new Profiler.Record[0];
        private long carryOver = 0L;
        private int defaultBufferSize;

        public MethodInvocationRecorder(int expectedBlockCnt) {
            this.measuredSize = this.defaultBufferSize = expectedBlockCnt * 10;
            this.measured = new Profiler.Record[this.measuredSize];
        }

        private synchronized void recordEntry(String blockName) {
            Profiler.Record r = new Profiler.Record(blockName);
            this.addMeasured(r);
            this.push(r);
            this.carryOver = 0L;
        }

        private synchronized void recordExit(String blockName, long duration) {
            Profiler.Record r = this.pop();
            if (r == null) {
                r = new Profiler.Record(blockName);
                this.addMeasured(r);
            }
            r.wallTime = duration;
            r.selfTime += duration - this.carryOver;
            for (int i = 0; i < this.stackPtr; ++i) {
                if (!this.stackArr[i].blockName.equals(blockName)) continue;
                r.wallTime = 0L;
                break;
            }
            r.selfTimeMin = r.selfTimeMax = r.selfTime;
            r.wallTimeMin = r.wallTimeMax = r.wallTime;
            Profiler.Record parent = this.peek();
            if (parent != null) {
                parent.selfTime -= duration;
            } else {
                this.carryOver = duration;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Profiler.Record[] getRecords(boolean reset) {
            Profiler.Record[] recs = null;
            MethodInvocationRecorder methodInvocationRecorder = this;
            synchronized (methodInvocationRecorder) {
                int stopPtr = this.compactMeasured();
                recs = new Profiler.Record[stopPtr];
                System.arraycopy(this.measured, 0, recs, 0, stopPtr);
                if (reset) {
                    this.reset();
                }
                for (int i = 0; i < recs.length; ++i) {
                    recs[i] = recs[i].duplicate();
                }
                return recs;
            }
        }

        private void push(Profiler.Record r) {
            if (this.stackPtr > this.stackBndr) {
                this.stackSize = (int)((double)this.stackSize * 1.5);
                this.stackBndr = (int)((double)this.stackBndr * 1.5);
                Profiler.Record[] newStack = new Profiler.Record[this.stackSize];
                System.arraycopy(this.stackArr, 0, newStack, 0, this.stackPtr + 1);
                this.stackArr = newStack;
            }
            this.stackArr[++this.stackPtr] = r;
            r.onStack = true;
        }

        private Profiler.Record pop() {
            Profiler.Record r;
            Profiler.Record record = r = this.stackPtr > -1 ? this.stackArr[this.stackPtr--] : null;
            if (r != null) {
                r.onStack = false;
            }
            return r;
        }

        private Profiler.Record peek() {
            return this.stackPtr > -1 ? this.stackArr[this.stackPtr] : null;
        }

        private void addMeasured(Profiler.Record r) {
            if (this.measuredPtr == this.measuredSize) {
                this.compactMeasured();
            }
            this.measured[this.measuredPtr++] = r;
        }

        private synchronized void reset() {
            Profiler.Record[] newMeasured = new Profiler.Record[this.defaultBufferSize + this.stackPtr + 1];
            if (this.stackPtr > -1) {
                System.arraycopy(this.stackArr, 0, newMeasured, 0, this.stackPtr + 1);
            }
            this.measuredPtr = this.stackPtr + 1;
            this.measured = newMeasured;
            this.measuredSize = this.measured.length;
        }

        private int compactMeasured() {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            int lastIndex = 0;
            for (int i = 0; i < this.measuredPtr; ++i) {
                Profiler.Record m = this.measured[i];
                if (m.onStack) continue;
                Integer newIndex = (Integer)indexMap.get(m.blockName);
                if (newIndex == null) {
                    newIndex = lastIndex++;
                    indexMap.put(m.blockName, newIndex);
                    this.measured[newIndex.intValue()] = m;
                    continue;
                }
                Profiler.Record mr = this.measured[newIndex];
                mr.selfTime += m.selfTime;
                mr.wallTime += m.wallTime;
                ++mr.invocations;
                mr.selfTimeMax = m.selfTime > mr.selfTimeMax ? m.selfTime : mr.selfTimeMax;
                mr.selfTimeMin = m.selfTime < mr.selfTimeMin ? m.selfTime : mr.selfTimeMin;
                mr.wallTimeMax = m.wallTime > mr.wallTimeMax ? m.wallTime : mr.wallTimeMax;
                mr.wallTimeMin = m.wallTime < mr.wallTimeMin ? m.wallTime : mr.wallTimeMin;
                for (int j = 0; j < this.stackPtr; ++j) {
                    if (this.stackArr[j] != m) continue;
                    this.stackArr[j] = mr;
                }
            }
            if (lastIndex + this.stackPtr + 1 == this.measuredSize) {
                int newMeasuredSize = (int)((double)this.measuredSize * 1.25) + (this.stackPtr + 1);
                if (newMeasuredSize == this.measuredSize) {
                    newMeasuredSize = this.measuredSize * 2 + (this.stackPtr + 1);
                }
                Profiler.Record[] newMeasured = new Profiler.Record[newMeasuredSize];
                System.arraycopy(this.measured, 0, newMeasured, 0, lastIndex);
                this.measured = newMeasured;
                this.measuredSize = newMeasuredSize;
            }
            System.arraycopy(this.stackArr, 0, this.measured, lastIndex, this.stackPtr + 1);
            this.measuredPtr = lastIndex + this.stackPtr + 1;
            return lastIndex;
        }
    }
}

