/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ArrayAllocInstrumentor
extends MethodInstrumentor {
    public ArrayAllocInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        String desc = null;
        if (opcode == 188) {
            desc = InstrumentUtils.arrayDescriptorFor(operand);
            this.onBeforeArrayNew(this.getPlainType(desc), 1);
        }
        super.visitIntInsn(opcode, operand);
        if (opcode == 188) {
            this.onAfterArrayNew(this.getPlainType(desc), 1);
        }
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 189) {
            this.onBeforeArrayNew("L" + desc + ";", 1);
        }
        super.visitTypeInsn(opcode, desc);
        if (opcode == 189) {
            this.onAfterArrayNew("L" + desc + ";", 1);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        String type = this.getPlainType(desc);
        this.onBeforeArrayNew(type, dims);
        super.visitMultiANewArrayInsn(desc, dims);
        this.onAfterArrayNew(type, dims);
    }

    protected void onBeforeArrayNew(String desc, int dims) {
        this.println("before allocating " + desc);
    }

    protected void onAfterArrayNew(String desc, int dims) {
        this.visitInsn(89);
        this.printObject();
    }

    private String getPlainType(String desc) {
        int index = desc.lastIndexOf("[") + 1;
        if (index > 0) {
            return desc.substring(index);
        }
        return desc;
    }

    public static void main(final String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.ArrayAllocInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new ArrayAllocInstrumentor(mv, args[0], args[0], access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

