/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class FieldAccessInstrumentor
extends MethodInstrumentor {
    protected boolean isStaticAccess = false;

    public FieldAccessInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        boolean get = opcode == 180 || opcode == 178;
        boolean bl = this.isStaticAccess = opcode == 178 || opcode == 179;
        if (get) {
            this.onBeforeGetField(opcode, owner, name, desc);
        } else {
            this.onBeforePutField(opcode, owner, name, desc);
        }
        super.visitFieldInsn(opcode, owner, name, desc);
        if (get) {
            this.onAfterGetField(opcode, owner, name, desc);
        } else {
            this.onAfterPutField(opcode, owner, name, desc);
        }
    }

    protected void onBeforeGetField(int opcode, String owner, String name, String desc) {
    }

    protected void onAfterGetField(int opcode, String owner, String name, String desc) {
    }

    protected void onBeforePutField(int opcode, String owner, String name, String desc) {
    }

    protected void onAfterPutField(int opcode, String owner, String name, String desc) {
    }

    public static void main(final String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.FieldAccessInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new FieldAccessInstrumentor(mv, args[0], args[0], access, name, desc){

                    @Override
                    protected void onAfterGetField(int opcode, String owner, String name, String desc) {
                        this.println("after get: " + owner + "." + name);
                    }

                    @Override
                    protected void onAfterPutField(int opcode, String owner, String name, String desc) {
                        this.println("after put: " + owner + "." + name);
                    }

                    @Override
                    protected void onBeforeGetField(int opcode, String owner, String name, String desc) {
                        this.println("before get: " + owner + "." + name);
                    }

                    @Override
                    protected void onBeforePutField(int opcode, String owner, String name, String desc) {
                        this.println("before put: " + owner + "." + name);
                    }
                };
            }
        });
        fos.write(writer.toByteArray());
    }
}

