/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.annotations.Kind;
import com.sun.btrace.annotations.Where;
import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.ArrayAccessInstrumentor;
import com.sun.btrace.runtime.ArrayAllocInstrumentor;
import com.sun.btrace.runtime.CatchInstrumentor;
import com.sun.btrace.runtime.ClassFilter;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.runtime.ErrorReturnInstrumentor;
import com.sun.btrace.runtime.FieldAccessInstrumentor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.LineNumberInstrumentor;
import com.sun.btrace.runtime.Location;
import com.sun.btrace.runtime.MethodCallInstrumentor;
import com.sun.btrace.runtime.MethodCopier;
import com.sun.btrace.runtime.MethodEntryInstrumentor;
import com.sun.btrace.runtime.MethodInstrumentor;
import com.sun.btrace.runtime.MethodReturnInstrumentor;
import com.sun.btrace.runtime.ObjectAllocInstrumentor;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.Preprocessor;
import com.sun.btrace.runtime.SynchronizedInstrumentor;
import com.sun.btrace.runtime.ThrowInstrumentor;
import com.sun.btrace.runtime.TypeCheckInstrumentor;
import com.sun.btrace.runtime.TypeUtils;
import com.sun.btrace.runtime.Verifier;
import com.sun.btrace.util.LocalVariablesSorter;
import com.sun.btrace.util.TimeStampGenerator;
import com.sun.btrace.util.TimeStampHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;

public class Instrumentor
extends ClassAdapter {
    private String btraceClassName;
    private ClassReader btraceClass;
    private List<OnMethod> onMethods;
    private List<OnMethod> applicableOnMethods;
    private Set<OnMethod> calledOnMethods;
    private String className;
    private String superName;
    private Class clazz;
    private boolean usesTimeStamp = false;
    private boolean timeStampExisting = false;

    public Instrumentor(Class clazz, String btraceClassName, ClassReader btraceClass, List<OnMethod> onMethods, ClassVisitor cv) {
        super(cv);
        this.clazz = clazz;
        this.btraceClassName = btraceClassName.replace('.', '/');
        this.btraceClass = btraceClass;
        this.onMethods = onMethods;
        this.applicableOnMethods = new ArrayList<OnMethod>();
        this.calledOnMethods = new HashSet<OnMethod>();
    }

    public Instrumentor(Class clazz, String btraceClassName, byte[] btraceCode, List<OnMethod> onMethods, ClassVisitor cv) {
        this(clazz, btraceClassName, new ClassReader(btraceCode), onMethods, cv);
    }

    public final boolean hasMatch() {
        return !this.calledOnMethods.isEmpty();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.usesTimeStamp = false;
        this.timeStampExisting = false;
        this.className = name;
        this.superName = superName;
        String externalName = name.replace('/', '.');
        for (OnMethod om : this.onMethods) {
            String probeClazz = om.getClazz();
            if (probeClazz.length() == 0) continue;
            char firstChar = probeClazz.charAt(0);
            if (firstChar == '/' && Constants.REGEX_SPECIFIER.matcher(probeClazz).matches()) {
                probeClazz = probeClazz.substring(1, probeClazz.length() - 1);
                try {
                    if (!externalName.matches(probeClazz)) continue;
                    this.applicableOnMethods.add(om);
                }
                catch (PatternSyntaxException pse) {
                    Instrumentor.reportPatternSyntaxException(probeClazz);
                }
                continue;
            }
            if (firstChar == '+') {
                String superType = probeClazz.substring(1);
                String superTypeInternal = superType.replace('.', '/');
                if (!ClassFilter.isSubTypeOf(this.clazz, superType) && !superName.equals(superTypeInternal) && !Instrumentor.isInArray(interfaces, superTypeInternal)) continue;
                this.applicableOnMethods.add(om);
                continue;
            }
            if (!probeClazz.equals(externalName)) continue;
            this.applicableOnMethods.add(om);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        String extName = Type.getType(desc).getClassName();
        for (OnMethod om : this.onMethods) {
            String probeClazz = om.getClazz();
            if (probeClazz.length() <= 0 || probeClazz.charAt(0) != '@' || (probeClazz = probeClazz.substring(1)).length() == 0) continue;
            if (Constants.REGEX_SPECIFIER.matcher(probeClazz).matches()) {
                probeClazz = probeClazz.substring(1, probeClazz.length() - 1);
                try {
                    if (!extName.matches(probeClazz)) continue;
                    this.applicableOnMethods.add(om);
                }
                catch (PatternSyntaxException pse) {
                    Instrumentor.reportPatternSyntaxException(probeClazz);
                }
                continue;
            }
            if (!probeClazz.equals(extName)) continue;
            this.applicableOnMethods.add(om);
        }
        return av;
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.applicableOnMethods.isEmpty() || (access & 0x400) != 0 || (access & 0x100) != 0 || name.startsWith("$btrace$")) {
            return methodVisitor;
        }
        if (name.equals("$btrace$time$stamp")) {
            this.timeStampExisting = true;
            return methodVisitor;
        }
        LocalVariablesSorter.Memento externalState = new LocalVariablesSorter.Memento();
        final LocalVariablesSorter lvs = new LocalVariablesSorter(access, desc, methodVisitor, externalState);
        methodVisitor = lvs;
        for (OnMethod om : this.applicableOnMethods) {
            if (om.getLocation().getValue() == Kind.LINE) {
                methodVisitor = this.instrumentorFor(om, methodVisitor, lvs, access, name, desc);
                continue;
            }
            String methodName = om.getMethod();
            if (methodName.equals("")) {
                methodName = om.getTargetName();
            }
            if (methodName.equals(name) && this.typeMatches(om.getType(), desc)) {
                methodVisitor = this.instrumentorFor(om, methodVisitor, lvs, access, name, desc);
                continue;
            }
            if (methodName.charAt(0) != '/' || !Constants.REGEX_SPECIFIER.matcher(methodName).matches()) continue;
            methodName = methodName.substring(1, methodName.length() - 1);
            try {
                if (!name.matches(methodName) || !this.typeMatches(om.getType(), desc)) continue;
                methodVisitor = this.instrumentorFor(om, methodVisitor, lvs, access, name, desc);
            }
            catch (PatternSyntaxException pse) {
                Instrumentor.reportPatternSyntaxException(name);
            }
        }
        return new MethodAdapter(methodVisitor){

            @Override
            public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                for (OnMethod om : Instrumentor.this.applicableOnMethods) {
                    String extAnnoName = Type.getType(annoDesc).getClassName();
                    String annoName = om.getMethod();
                    if (annoName.length() <= 0 || annoName.charAt(0) != '@' || (annoName = annoName.substring(1)).length() == 0) continue;
                    if (Constants.REGEX_SPECIFIER.matcher(annoName).matches()) {
                        annoName = annoName.substring(1, annoName.length() - 1);
                        try {
                            if (!extAnnoName.matches(annoName)) continue;
                            this.mv = Instrumentor.this.instrumentorFor(om, this.mv, lvs, access, name, desc);
                        }
                        catch (PatternSyntaxException pse) {
                            Instrumentor.reportPatternSyntaxException(extAnnoName);
                        }
                        continue;
                    }
                    if (!annoName.equals(extAnnoName)) continue;
                    this.mv = Instrumentor.this.instrumentorFor(om, this.mv, lvs, access, name, desc);
                }
                return this.mv.visitAnnotation(annoDesc, visible);
            }
        };
    }

    private MethodVisitor instrumentorFor(final OnMethod om, MethodVisitor mv, final LocalVariablesSorter lvs, int access, String name, String desc) {
        final Location loc = om.getLocation();
        final Where where = loc.getWhere();
        final Type[] actionArgTypes = Type.getArgumentTypes(om.getTargetDescriptor());
        final int numActionArgs = actionArgTypes.length;
        final int[] tsindex = new int[]{-1, -1};
        switch (loc.getValue()) {
            case ARRAY_GET: {
                return new ArrayAccessInstrumentor(mv, this.className, this.superName, access, name, desc){
                    int[] argsIndex;
                    private final int INSTANCE_PTR = 0;
                    private final int INDEX_PTR = 1;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.argsIndex = new int[]{-1, -1};
                        this.INSTANCE_PTR = 0;
                        this.INDEX_PTR = 1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onBeforeArrayLoad(int opcode) {
                        MethodInstrumentor.ValidationResult vr;
                        Type arrtype = TypeUtils.getArrayType(opcode);
                        Type retType = TypeUtils.getElementType(opcode);
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        if (where == Where.AFTER) {
                            this.addExtraTypeInfo(om.getReturnParameter(), retType);
                        }
                        if ((vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{arrtype, Type.INT_TYPE})).isValid()) {
                            lvs.freeze();
                            try {
                                if (!vr.isAny()) {
                                    this.dup2();
                                    this.argsIndex[1] = lvs.newLocal(Type.INT_TYPE);
                                    this.argsIndex[0] = lvs.newLocal(arrtype);
                                }
                                if (where == Where.BEFORE) {
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(1), Type.INT_TYPE, this.argsIndex[1]), new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), arrtype, this.argsIndex[0]), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onAfterArrayLoad(int opcode) {
                        if (where == Where.AFTER) {
                            Type arrtype = TypeUtils.getArrayType(opcode);
                            Type retType = TypeUtils.getElementType(opcode);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getReturnParameter(), retType);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{arrtype, Type.INT_TYPE});
                            if (vr.isValid()) {
                                lvs.freeze();
                                try {
                                    int retValIndex = -1;
                                    if (om.getReturnParameter() != -1) {
                                        this.dupArrayValue(opcode);
                                        retValIndex = lvs.newLocal(retType);
                                    }
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(1), Type.INT_TYPE, this.argsIndex[1]), new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), arrtype, this.argsIndex[0]), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getReturnParameter(), retType, retValIndex), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }
                };
            }
            case ARRAY_SET: {
                return new ArrayAccessInstrumentor(mv, this.className, this.superName, access, name, desc){
                    int[] argsIndex;
                    private final int INSTANCE_PTR = 0;
                    private final int INDEX_PTR = 1;
                    private final int VALUE_PTR = 2;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.argsIndex = new int[]{-1, -1, -1};
                        this.INSTANCE_PTR = 0;
                        this.INDEX_PTR = 1;
                        this.VALUE_PTR = 2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onBeforeArrayStore(int opcode) {
                        Type elementType = TypeUtils.getElementType(opcode);
                        Type arrayType = TypeUtils.getArrayType(opcode);
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{arrayType, Type.INT_TYPE, elementType});
                        if (vr.isValid()) {
                            lvs.freeze();
                            try {
                                if (!vr.isAny()) {
                                    this.argsIndex[2] = lvs.newLocal(elementType);
                                    this.dup2();
                                    this.argsIndex[1] = lvs.newLocal(Type.INT_TYPE);
                                    this.argsIndex[0] = lvs.newLocal(TypeUtils.getArrayType(opcode));
                                    this.loadLocal(elementType, this.argsIndex[2]);
                                }
                                if (where == Where.BEFORE) {
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), arrayType, this.argsIndex[0]), new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(1), Type.INT_TYPE, this.argsIndex[1]), new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(2), elementType, this.argsIndex[2]), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onAfterArrayStore(int opcode) {
                        if (where == Where.AFTER) {
                            Type elementType = TypeUtils.getElementType(opcode);
                            Type arrayType = TypeUtils.getArrayType(opcode);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{arrayType, Type.INT_TYPE, elementType});
                            if (vr.isValid()) {
                                lvs.freeze();
                                try {
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), arrayType, this.argsIndex[0]), new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(1), Type.INT_TYPE, this.argsIndex[1]), new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(2), elementType, this.argsIndex[2]), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }
                };
            }
            case CALL: {
                return new MethodCallInstrumentor(mv, this.className, this.superName, access, name, desc){
                    private String localClassName;
                    private String localMethodName;
                    private int returnVarIndex;
                    int[] backupArgsIndexes;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.localClassName = loc.getClazz();
                        this.localMethodName = loc.getMethod();
                        this.returnVarIndex = -1;
                    }

                    private void injectBtrace(MethodInstrumentor.ValidationResult vr, String method, Type returnType) {
                        MethodInstrumentor.ArgumentProvider[] actionArgs = new MethodInstrumentor.ArgumentProvider[actionArgTypes.length + 6];
                        for (int i = 0; i < vr.getArgCnt(); ++i) {
                            int index = vr.getArgIdx(i);
                            Type t = actionArgTypes[index];
                            actionArgs[i] = TypeUtils.isAnyTypeArray(t) ? new MethodInstrumentor.AnyTypeArgProvider(this, i, this.backupArgsIndexes[i + 1]) : new MethodInstrumentor.LocalVarArgProvider(this, index, actionArgTypes[index], this.backupArgsIndexes[i + 1]);
                        }
                        actionArgs[actionArgTypes.length] = new MethodInstrumentor.LocalVarArgProvider(this, om.getReturnParameter(), returnType, this.returnVarIndex);
                        actionArgs[actionArgTypes.length + 1] = new MethodInstrumentor.LocalVarArgProvider(this, om.getTargetInstanceParameter(), TypeUtils.objectType, this.backupArgsIndexes[0]);
                        actionArgs[actionArgTypes.length + 2] = new MethodInstrumentor.ConstantArgProvider(this, om.getTargetMethodOrFieldParameter(), method);
                        actionArgs[actionArgTypes.length + 3] = new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className);
                        actionArgs[actionArgTypes.length + 4] = new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn()));
                        actionArgs[actionArgTypes.length + 5] = new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0);
                        this.loadArguments(actionArgs);
                        Instrumentor.this.invokeBTraceAction(this, om);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onBeforeCallMethod(int opcode, String owner, String name, String desc) {
                        if (this.isStatic() && om.getSelfParameter() > -1) {
                            return;
                        }
                        if (Instrumentor.this.matches(this.localClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.localMethodName, name) && Instrumentor.this.typeMatches(loc.getType(), desc)) {
                            MethodInstrumentor.ValidationResult vr;
                            String method = (om.isTargetMethodOrFieldFqn() ? owner + "." : "") + name + (om.isTargetMethodOrFieldFqn() ? desc : "");
                            Type[] calledMethodArgs = Type.getArgumentTypes(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            if (where == Where.AFTER) {
                                this.addExtraTypeInfo(om.getReturnParameter(), Type.getReturnType(desc));
                            }
                            if ((vr = this.validateArguments(om, this.isStatic(), actionArgTypes, calledMethodArgs)).isValid()) {
                                lvs.freeze();
                                try {
                                    boolean isStaticCall;
                                    boolean bl = isStaticCall = opcode == 184;
                                    if (isStaticCall ? om.getTargetInstanceParameter() != -1 : where == Where.BEFORE && name.equals("<init>")) {
                                        return;
                                    }
                                    this.backupArgsIndexes = this.backupStack(lvs, Type.getArgumentTypes(desc), isStaticCall);
                                    if (where == Where.BEFORE) {
                                        this.injectBtrace(vr, method, Type.getReturnType(desc));
                                    }
                                    this.restoreStack(this.backupArgsIndexes, Type.getArgumentTypes(desc), isStaticCall);
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onAfterCallMethod(int opcode, String owner, String name, String desc) {
                        if (this.isStatic() && om.getSelfParameter() != -1) {
                            return;
                        }
                        if (where == Where.AFTER && Instrumentor.this.matches(this.localClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.localMethodName, name) && Instrumentor.this.typeMatches(loc.getType(), desc)) {
                            Type returnType = Type.getReturnType(desc);
                            Type[] calledMethodArgs = Type.getArgumentTypes(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getReturnParameter(), returnType);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, calledMethodArgs);
                            if (vr.isValid()) {
                                lvs.freeze();
                                try {
                                    boolean withReturn;
                                    String method = name + desc;
                                    boolean bl = withReturn = om.getReturnParameter() != -1 && returnType != Type.VOID_TYPE;
                                    if (withReturn) {
                                        int index;
                                        this.returnVarIndex = index = lvs.newLocal(returnType);
                                    }
                                    this.injectBtrace(vr, method, returnType);
                                    if (withReturn) {
                                        this.loadLocal(returnType, this.returnVarIndex);
                                    }
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }
                };
            }
            case CATCH: {
                return new CatchInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onCatch(String type) {
                        Type exctype = Type.getObjectType(type);
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{exctype});
                        if (vr.isValid()) {
                            int index = -1;
                            lvs.freeze();
                            try {
                                if (!vr.isAny()) {
                                    this.dup();
                                    index = lvs.newLocal(exctype);
                                }
                                this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), exctype, index), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }
                };
            }
            case CHECKCAST: {
                return new TypeCheckInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void callAction(int opcode, String desc) {
                        if (opcode == 192) {
                            Type castType = Type.getObjectType(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{castType});
                            if (vr.isValid()) {
                                lvs.freeze();
                                try {
                                    int castTypeIndex = -1;
                                    if (!vr.isAny()) {
                                        this.dup();
                                        castTypeIndex = lvs.newLocal(castType);
                                    }
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), castType, castTypeIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (where == Where.BEFORE) {
                            this.callAction(opcode, desc);
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (where == Where.AFTER) {
                            this.callAction(opcode, desc);
                        }
                    }
                };
            }
            case ENTRY: {
                return new MethodEntryInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void injectBtrace(MethodInstrumentor.ValidationResult vr) {
                        lvs.freeze();
                        try {
                            MethodInstrumentor.ArgumentProvider[] actionArgs = new MethodInstrumentor.ArgumentProvider[actionArgTypes.length + 3];
                            int ptr = this.isStatic() ? 0 : 1;
                            for (int i = 0; i < vr.getArgCnt(); ++i) {
                                int index = vr.getArgIdx(i);
                                Type t = actionArgTypes[index];
                                if (TypeUtils.isAnyTypeArray(t)) {
                                    actionArgs[i] = new MethodInstrumentor.AnyTypeArgProvider(this, index, ptr);
                                    ++ptr;
                                    continue;
                                }
                                actionArgs[i] = new MethodInstrumentor.LocalVarArgProvider(this, index, t, ptr);
                                ptr += actionArgTypes[index].getSize();
                            }
                            actionArgs[actionArgTypes.length] = new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn()));
                            actionArgs[actionArgTypes.length + 1] = new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", "."));
                            actionArgs[actionArgTypes.length + 2] = new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0);
                            this.loadArguments(actionArgs);
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                        finally {
                            lvs.unfreeze();
                        }
                    }

                    private void callAction() {
                        if (this.isStatic() && om.getSelfParameter() > -1) {
                            return;
                        }
                        Type[] calledMethodArgs = Type.getArgumentTypes(this.getDescriptor());
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, calledMethodArgs);
                        if (vr.isValid()) {
                            this.injectBtrace(vr);
                        }
                    }

                    @Override
                    protected void onMethodEntry() {
                        if (numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        } else {
                            this.callAction();
                        }
                    }
                };
            }
            case ERROR: {
                return new ErrorReturnInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onErrorReturn() {
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.throwableType});
                        if (vr.isValid()) {
                            int throwableIndex = -1;
                            lvs.freeze();
                            try {
                                if (!vr.isAny()) {
                                    this.dup();
                                    throwableIndex = lvs.newLocal(TypeUtils.throwableType);
                                }
                                this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), TypeUtils.throwableType, throwableIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }
                };
            }
            case FIELD_GET: {
                return new FieldAccessInstrumentor(mv, this.className, this.superName, access, name, desc){
                    int calledInstanceIndex;
                    private String targetClassName;
                    private String targetFieldName;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.calledInstanceIndex = -1;
                        this.targetClassName = loc.getClazz();
                        this.targetFieldName = (om.isTargetMethodOrFieldFqn() ? this.targetClassName + "." : "") + loc.getField();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onBeforeGetField(int opcode, String owner, String name, String desc) {
                        if (om.getTargetInstanceParameter() != -1 && this.isStaticAccess) {
                            return;
                        }
                        if (Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            MethodInstrumentor.ValidationResult vr;
                            Type fldType = Type.getType(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            if (where == Where.AFTER) {
                                this.addExtraTypeInfo(om.getReturnParameter(), fldType);
                            }
                            if ((vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[0])).isValid()) {
                                lvs.freeze();
                                try {
                                    if (om.getTargetInstanceParameter() != -1) {
                                        this.dup();
                                        this.calledInstanceIndex = lvs.newLocal(TypeUtils.objectType);
                                    }
                                    if (where == Where.BEFORE) {
                                        this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, om.getTargetInstanceParameter(), TypeUtils.objectType, this.calledInstanceIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getTargetMethodOrFieldParameter(), this.targetFieldName), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onAfterGetField(int opcode, String owner, String name, String desc) {
                        if (om.getTargetInstanceParameter() != -1 && this.isStaticAccess) {
                            return;
                        }
                        if (where == Where.AFTER && Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            Type fldType = Type.getType(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            this.addExtraTypeInfo(om.getReturnParameter(), fldType);
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[0]);
                            if (vr.isValid()) {
                                int returnValIndex = -1;
                                lvs.freeze();
                                try {
                                    if (om.getReturnParameter() != -1) {
                                        this.dupValue(desc);
                                        returnValIndex = lvs.newLocal(fldType);
                                    }
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, om.getTargetInstanceParameter(), TypeUtils.objectType, this.calledInstanceIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getTargetMethodOrFieldParameter(), this.targetFieldName), new MethodInstrumentor.LocalVarArgProvider(this, om.getReturnParameter(), fldType, returnValIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }
                };
            }
            case FIELD_SET: {
                return new FieldAccessInstrumentor(mv, this.className, this.superName, access, name, desc){
                    private String targetClassName;
                    private String targetFieldName;
                    private int calledInstanceIndex;
                    private int fldValueIndex;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.targetClassName = loc.getClazz();
                        this.targetFieldName = (om.isTargetMethodOrFieldFqn() ? this.targetClassName + "." : "") + loc.getField();
                        this.calledInstanceIndex = -1;
                        this.fldValueIndex = -1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onBeforePutField(int opcode, String owner, String name, String desc) {
                        if (om.getTargetInstanceParameter() != -1 && this.isStaticAccess) {
                            return;
                        }
                        if (Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            Type fieldType = Type.getType(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{fieldType});
                            if (vr.isValid()) {
                                lvs.freeze();
                                try {
                                    if (!vr.isAny()) {
                                        this.fldValueIndex = lvs.newLocal(fieldType);
                                    }
                                    if (om.getTargetInstanceParameter() != -1) {
                                        this.dup();
                                        this.calledInstanceIndex = lvs.newLocal(TypeUtils.objectType);
                                    }
                                    if (!vr.isAny()) {
                                        this.loadLocal(fieldType, this.fldValueIndex);
                                    }
                                    if (where == Where.BEFORE) {
                                        this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), fieldType, this.fldValueIndex), new MethodInstrumentor.LocalVarArgProvider(this, om.getTargetInstanceParameter(), TypeUtils.objectType, this.calledInstanceIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getTargetMethodOrFieldParameter(), this.targetFieldName), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onAfterPutField(int opcode, String owner, String name, String desc) {
                        if (om.getTargetInstanceParameter() != -1 && this.isStaticAccess) {
                            return;
                        }
                        if (where == Where.AFTER && Instrumentor.this.matches(this.targetClassName, owner.replace('/', '.')) && Instrumentor.this.matches(this.targetFieldName, name)) {
                            Type fieldType = Type.getType(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{fieldType});
                            if (vr.isValid()) {
                                lvs.freeze();
                                try {
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), fieldType, this.fldValueIndex), new MethodInstrumentor.LocalVarArgProvider(this, om.getTargetInstanceParameter(), TypeUtils.objectType, this.calledInstanceIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getTargetMethodOrFieldParameter(), this.targetFieldName), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }
                };
            }
            case INSTANCEOF: {
                return new TypeCheckInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void callAction(int opcode, String desc) {
                        if (opcode == 193) {
                            Type castType = Type.getObjectType(desc);
                            this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                            MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{castType});
                            if (vr.isValid()) {
                                int castTypeIndex = -1;
                                lvs.freeze();
                                try {
                                    if (!vr.isAny()) {
                                        this.dup();
                                        castTypeIndex = lvs.newLocal(castType);
                                    }
                                    this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), castType, castTypeIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                    Instrumentor.this.invokeBTraceAction(this, om);
                                }
                                finally {
                                    lvs.unfreeze();
                                }
                            }
                        }
                    }

                    @Override
                    protected void onBeforeTypeCheck(int opcode, String desc) {
                        if (where == Where.BEFORE) {
                            this.callAction(opcode, desc);
                        }
                    }

                    @Override
                    protected void onAfterTypeCheck(int opcode, String desc) {
                        if (where == Where.AFTER) {
                            this.callAction(opcode, desc);
                        }
                    }
                };
            }
            case LINE: {
                return new LineNumberInstrumentor(mv, this.className, this.superName, access, name, desc){
                    private int onLine;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.onLine = loc.getLine();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void callOnLine(int line) {
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{Type.INT_TYPE});
                        if (vr.isValid()) {
                            lvs.freeze();
                            try {
                                this.loadArguments(new MethodInstrumentor.ConstantArgProvider(this, vr.getArgIdx(0), line), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }

                    @Override
                    protected void onBeforeLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.BEFORE) {
                            this.callOnLine(line);
                        }
                    }

                    @Override
                    protected void onAfterLine(int line) {
                        if ((line == this.onLine || this.onLine == -1) && where == Where.AFTER) {
                            this.callOnLine(line);
                        }
                    }
                };
            }
            case NEW: {
                return new ObjectAllocInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void beforeObjectNew(String desc) {
                        if (loc.getWhere() == Where.BEFORE) {
                            String extName = desc.replace('/', '.');
                            if (Instrumentor.this.matches(loc.getClazz(), extName)) {
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.stringType});
                                if (vr.isValid()) {
                                    lvs.freeze();
                                    try {
                                        this.loadArguments(new MethodInstrumentor.ConstantArgProvider(this, vr.getArgIdx(0), extName), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                    finally {
                                        lvs.unfreeze();
                                    }
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void afterObjectNew(String desc) {
                        if (loc.getWhere() == Where.AFTER) {
                            String extName = desc.replace('/', '.');
                            if (Instrumentor.this.matches(loc.getClazz(), extName)) {
                                Type instType = Type.getObjectType(desc);
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                                this.addExtraTypeInfo(om.getReturnParameter(), instType);
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.stringType});
                                if (vr.isValid()) {
                                    int returnValIndex = -1;
                                    lvs.freeze();
                                    try {
                                        if (om.getReturnParameter() != -1) {
                                            this.dupValue(instType);
                                            returnValIndex = lvs.newLocal(instType);
                                        }
                                        this.loadArguments(new MethodInstrumentor.ConstantArgProvider(this, vr.getArgIdx(0), extName), new MethodInstrumentor.LocalVarArgProvider(this, om.getReturnParameter(), instType, returnValIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                    finally {
                                        lvs.unfreeze();
                                    }
                                }
                            }
                        }
                    }
                };
            }
            case NEWARRAY: {
                return new ArrayAllocInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onBeforeArrayNew(String desc, int dims) {
                        if (where == Where.BEFORE) {
                            String extName = TypeUtils.getJavaType(desc);
                            String type = TypeUtils.objectOrArrayType(loc.getClazz());
                            if (Instrumentor.this.matches(type, desc)) {
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.stringType, Type.INT_TYPE});
                                if (vr.isValid()) {
                                    lvs.freeze();
                                    try {
                                        this.loadArguments(new MethodInstrumentor.ConstantArgProvider(this, vr.getArgIdx(0), extName), new MethodInstrumentor.ConstantArgProvider(this, vr.getArgIdx(1), dims), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                    finally {
                                        lvs.unfreeze();
                                    }
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onAfterArrayNew(String desc, int dims) {
                        if (where == Where.AFTER) {
                            String extName = TypeUtils.getJavaType(desc);
                            String type = TypeUtils.objectOrArrayType(loc.getClazz());
                            if (Instrumentor.this.matches(type, desc)) {
                                StringBuilder arrayType = new StringBuilder();
                                for (int i = 0; i < dims; ++i) {
                                    arrayType.append("[");
                                }
                                arrayType.append(desc);
                                Type instType = Type.getObjectType(arrayType.toString());
                                this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                                this.addExtraTypeInfo(om.getReturnParameter(), instType);
                                MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.stringType, Type.INT_TYPE});
                                if (vr.isValid()) {
                                    int returnValIndex = -1;
                                    lvs.freeze();
                                    try {
                                        if (om.getReturnParameter() != -1) {
                                            this.dupValue(instType);
                                            returnValIndex = lvs.newLocal(instType);
                                        }
                                        this.loadArguments(new MethodInstrumentor.ConstantArgProvider(this, vr.getArgIdx(0), extName), new MethodInstrumentor.ConstantArgProvider(this, vr.getArgIdx(1), dims), new MethodInstrumentor.LocalVarArgProvider(this, om.getReturnParameter(), instType, returnValIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                        Instrumentor.this.invokeBTraceAction(this, om);
                                    }
                                    finally {
                                        lvs.unfreeze();
                                    }
                                }
                            }
                        }
                    }
                };
            }
            case RETURN: {
                if (where != Where.BEFORE) {
                    return mv;
                }
                MethodReturnInstrumentor mri = new MethodReturnInstrumentor(mv, this.className, this.superName, access, name, desc){
                    int retValIndex;
                    MethodInstrumentor.ValidationResult vr;
                    {
                        super(x0, x1, x2, x3, x4, x5);
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        this.addExtraTypeInfo(om.getReturnParameter(), this.getReturnType());
                        this.vr = this.validateArguments(om, this.isStatic(), actionArgTypes, Type.getArgumentTypes(this.getDescriptor()));
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void callAction(int retOpCode) {
                        if (!this.vr.isValid()) {
                            return;
                        }
                        lvs.freeze();
                        try {
                            if (om.getReturnParameter() != -1) {
                                this.dupReturnValue(retOpCode);
                                this.retValIndex = lvs.newLocal(this.getReturnType());
                            }
                            if (om.getDurationParameter() != -1) {
                                Instrumentor.this.usesTimeStamp = true;
                            }
                            MethodInstrumentor.ArgumentProvider[] actionArgs = new MethodInstrumentor.ArgumentProvider[actionArgTypes.length + 5];
                            int ptr = this.isStatic() ? 0 : 1;
                            for (int i = 0; i < this.vr.getArgCnt(); ++i) {
                                int index = this.vr.getArgIdx(i);
                                Type t = actionArgTypes[index];
                                if (TypeUtils.isAnyTypeArray(t)) {
                                    actionArgs[i] = new MethodInstrumentor.AnyTypeArgProvider(this, i, ptr);
                                    ++ptr;
                                    continue;
                                }
                                actionArgs[i] = new MethodInstrumentor.LocalVarArgProvider(this, index, t, ptr);
                                ptr += actionArgTypes[index].getSize();
                            }
                            actionArgs[actionArgTypes.length] = new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn()));
                            actionArgs[actionArgTypes.length + 1] = new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", "."));
                            actionArgs[actionArgTypes.length + 2] = new MethodInstrumentor.LocalVarArgProvider(this, om.getReturnParameter(), this.getReturnType(), this.retValIndex);
                            actionArgs[actionArgTypes.length + 3] = new MethodInstrumentor.ArgumentProvider(om.getDurationParameter()){

                                @Override
                                public void doProvide() {
                                    if (tsindex[0] != -1 && tsindex[1] != -1) {
                                        this.loadLocal(Type.LONG_TYPE, tsindex[1]);
                                        this.loadLocal(Type.LONG_TYPE, tsindex[0]);
                                        this.visitInsn(101);
                                    }
                                }
                            };
                            actionArgs[actionArgTypes.length + 4] = new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0);
                            this.loadArguments(actionArgs);
                            Instrumentor.this.invokeBTraceAction(this, om);
                        }
                        finally {
                            lvs.unfreeze();
                        }
                    }

                    @Override
                    protected void onMethodReturn(int opcode) {
                        if (numActionArgs == 0) {
                            Instrumentor.this.invokeBTraceAction(this, om);
                        } else {
                            this.callAction(opcode);
                        }
                    }

                    @Override
                    public boolean usesTimeStamp() {
                        return this.vr.isValid() && om.getDurationParameter() != -1;
                    }
                };
                if (om.getDurationParameter() != -1) {
                    return new TimeStampGenerator(lvs, tsindex, this.className, this.superName, access, name, desc, mri, new int[]{177, 172, 174, 175, 173, 176});
                }
                return mri;
            }
            case SYNC_ENTRY: {
                return new SynchronizedInstrumentor(lvs, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void callAction() {
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.objectType});
                        if (vr.isValid()) {
                            int index = -1;
                            lvs.freeze();
                            try {
                                if (!vr.isAny()) {
                                    this.dup();
                                    index = lvs.newLocal(TypeUtils.objectType);
                                }
                                this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), TypeUtils.objectType, index), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                        if (where == Where.BEFORE) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                        if (where == Where.AFTER) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                    }

                    @Override
                    protected void onAfterSyncExit() {
                    }
                };
            }
            case SYNC_EXIT: {
                return new SynchronizedInstrumentor(lvs, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private void callAction() {
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.objectType});
                        if (vr.isValid()) {
                            int index = -1;
                            lvs.freeze();
                            try {
                                if (!vr.isAny()) {
                                    this.dup();
                                    index = lvs.newLocal(TypeUtils.objectType);
                                }
                                this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), TypeUtils.objectType, index), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }

                    @Override
                    protected void onBeforeSyncEntry() {
                    }

                    @Override
                    protected void onAfterSyncEntry() {
                    }

                    @Override
                    protected void onBeforeSyncExit() {
                        if (where == Where.BEFORE) {
                            this.callAction();
                        }
                    }

                    @Override
                    protected void onAfterSyncExit() {
                        if (where == Where.AFTER) {
                            this.callAction();
                        }
                    }
                };
            }
            case THROW: {
                return new ThrowInstrumentor(mv, this.className, this.superName, access, name, desc){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void onThrow() {
                        this.addExtraTypeInfo(om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className));
                        MethodInstrumentor.ValidationResult vr = this.validateArguments(om, this.isStatic(), actionArgTypes, new Type[]{TypeUtils.throwableType});
                        if (vr.isValid()) {
                            int throwableIndex = -1;
                            lvs.freeze();
                            try {
                                if (!vr.isAny()) {
                                    this.dup();
                                    throwableIndex = lvs.newLocal(TypeUtils.throwableType);
                                }
                                this.loadArguments(new MethodInstrumentor.LocalVarArgProvider(this, vr.getArgIdx(0), TypeUtils.throwableType, throwableIndex), new MethodInstrumentor.ConstantArgProvider(this, om.getClassNameParameter(), Instrumentor.this.className.replace("/", ".")), new MethodInstrumentor.ConstantArgProvider(this, om.getMethodParameter(), this.getName(om.isMethodFqn())), new MethodInstrumentor.LocalVarArgProvider(this, om.getSelfParameter(), Type.getObjectType(Instrumentor.this.className), 0));
                                Instrumentor.this.invokeBTraceAction(this, om);
                            }
                            finally {
                                lvs.unfreeze();
                            }
                        }
                    }
                };
            }
        }
        return mv;
    }

    private void introduceTimeStampHelper() {
        if (this.usesTimeStamp && !this.timeStampExisting) {
            TimeStampHelper.generateTimeStampGetter(this);
        }
    }

    @Override
    public void visitEnd() {
        int size = this.applicableOnMethods.size();
        ArrayList<MethodCopier.MethodInfo> mi = new ArrayList<MethodCopier.MethodInfo>(size);
        for (OnMethod om : this.calledOnMethods) {
            mi.add(new MethodCopier.MethodInfo(om.getTargetName(), om.getTargetDescriptor(), this.getActionMethodName(om.getTargetName()), 10));
        }
        this.introduceTimeStampHelper();
        MethodCopier copier = new MethodCopier(this.btraceClass, this.cv, mi){

            @Override
            protected MethodVisitor addMethod(int access, String name, String desc, String signature, String[] exceptions) {
                desc = desc.replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC);
                if (signature != null) {
                    signature = signature.replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC);
                }
                return super.addMethod(access, name, desc, signature, exceptions);
            }
        };
        copier.visitEnd();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java com.sun.btrace.runtime.Instrumentor <btrace-class> <target-class>]");
            System.exit(1);
        }
        String className = args[0].replace('.', '/') + ".class";
        FileInputStream fis = new FileInputStream(className);
        byte[] buf = new byte[(int)new File(className).length()];
        fis.read(buf);
        fis.close();
        ClassWriter writer = InstrumentUtils.newClassWriter();
        Verifier verifier = new Verifier(new Preprocessor(writer));
        InstrumentUtils.accept(new ClassReader(buf), verifier);
        buf = writer.toByteArray();
        FileOutputStream fos = new FileOutputStream(className);
        fos.write(buf);
        fos.close();
        String targetClass = args[1].replace('.', '/') + ".class";
        fis = new FileInputStream(targetClass);
        writer = InstrumentUtils.newClassWriter();
        ClassReader reader = new ClassReader(fis);
        InstrumentUtils.accept(reader, new Instrumentor(null, verifier.getClassName(), buf, verifier.getOnMethods(), (ClassVisitor)writer));
        fos = new FileOutputStream(targetClass);
        fos.write(writer.toByteArray());
    }

    private String getActionMethodName(String name) {
        return "$btrace$" + this.btraceClassName.replace('/', '$') + "$" + name;
    }

    private void invokeBTraceAction(MethodInstrumentor mv, OnMethod om) {
        mv.invokeStatic(this.className, this.getActionMethodName(om.getTargetName()), om.getTargetDescriptor().replace(Constants.ANYTYPE_DESC, Constants.OBJECT_DESC));
        this.calledOnMethods.add(om);
    }

    private boolean matches(String pattern, String input) {
        if (pattern.length() == 0) {
            return false;
        }
        if (pattern.charAt(0) == '/' && Constants.REGEX_SPECIFIER.matcher(pattern).matches()) {
            try {
                return input.matches(pattern.substring(1, pattern.length() - 1));
            }
            catch (PatternSyntaxException pse) {
                Instrumentor.reportPatternSyntaxException(pattern.substring(1, pattern.length() - 1));
                return false;
            }
        }
        return pattern.equals(input);
    }

    private boolean typeMatches(String decl, String desc) {
        if (decl.isEmpty()) {
            return true;
        }
        String d = TypeUtils.declarationToDescriptor(decl);
        Type[] args1 = Type.getArgumentTypes(d);
        Type[] args2 = Type.getArgumentTypes(desc);
        return TypeUtils.isCompatible(args1, args2);
    }

    private static boolean isInArray(String[] candidates, String given) {
        for (String c : candidates) {
            if (!c.equals(given)) continue;
            return true;
        }
        return false;
    }

    private static void reportPatternSyntaxException(String pattern) {
        System.err.println("btrace ERROR: invalid regex pattern - " + pattern);
    }
}

