/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class LineNumberInstrumentor
extends MethodInstrumentor {
    private int lastLine;

    public LineNumberInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        if (this.lastLine != 0) {
            this.onAfterLine(line - 1);
        }
        this.onBeforeLine(line);
        this.lastLine = line;
        super.visitLineNumber(line, start);
    }

    protected void onBeforeLine(int line) {
        this.println("before line " + line);
    }

    protected void onAfterLine(int line) {
        this.println("after line " + line);
    }

    public static void main(final String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.LineNumberInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new LineNumberInstrumentor(mv, args[0], args[0], access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

