/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class MethodCallInstrumentor
extends MethodInstrumentor {
    public MethodCallInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (name.startsWith("$btrace")) {
            super.visitMethodInsn(opcode, owner, name, desc);
            return;
        }
        this.onBeforeCallMethod(opcode, owner, name, desc);
        super.visitMethodInsn(opcode, owner, name, desc);
        this.onAfterCallMethod(opcode, owner, name, desc);
    }

    protected void onBeforeCallMethod(int opcode, String owner, String name, String desc) {
        this.println("before call: " + owner + "." + name + desc);
    }

    protected void onAfterCallMethod(int opcode, String owner, String name, String desc) {
        this.println("after call: " + owner + "." + name + desc);
    }

    public static void main(final String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.MethodCallInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodCallInstrumentor(mv, args[0], args[0], access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

