/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.OnMethod;
import com.sun.btrace.runtime.TypeUtils;
import com.sun.btrace.util.LocalVariablesSorter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class MethodInstrumentor
extends MethodAdapter {
    public static final String JAVA_LANG_THREAD_LOCAL = Type.getInternalName(ThreadLocal.class);
    public static final String JAVA_LANG_THREAD_LOCAL_GET = "get";
    public static final String JAVA_LANG_THREAD_LOCAL_GET_DESC = "()Ljava/lang/Object;";
    public static final String JAVA_LANG_THREAD_LOCAL_SET = "set";
    public static final String JAVA_LANG_THREAD_LOCAL_SET_DESC = "(Ljava/lang/Object;)V";
    public static final String JAVA_LANG_STRING = Type.getInternalName(String.class);
    public static final String JAVA_LANG_STRING_DESC = Type.getDescriptor(String.class);
    public static final String JAVA_LANG_NUMBER = Type.getInternalName(Number.class);
    public static final String JAVA_LANG_BOOLEAN = Type.getInternalName(Boolean.class);
    public static final String JAVA_LANG_CHARACTER = Type.getInternalName(Character.class);
    public static final String JAVA_LANG_BYTE = Type.getInternalName(Byte.class);
    public static final String JAVA_LANG_SHORT = Type.getInternalName(Short.class);
    public static final String JAVA_LANG_INTEGER = Type.getInternalName(Integer.class);
    public static final String JAVA_LANG_LONG = Type.getInternalName(Long.class);
    public static final String JAVA_LANG_FLOAT = Type.getInternalName(Float.class);
    public static final String JAVA_LANG_DOUBLE = Type.getInternalName(Double.class);
    public static final String BOX_VALUEOF = "valueOf";
    public static final String BOX_BOOLEAN_DESC = "(Z)Ljava/lang/Boolean;";
    public static final String BOX_CHARACTER_DESC = "(C)Ljava/lang/Character;";
    public static final String BOX_BYTE_DESC = "(B)Ljava/lang/Byte;";
    public static final String BOX_SHORT_DESC = "(S)Ljava/lang/Short;";
    public static final String BOX_INTEGER_DESC = "(I)Ljava/lang/Integer;";
    public static final String BOX_LONG_DESC = "(J)Ljava/lang/Long;";
    public static final String BOX_FLOAT_DESC = "(F)Ljava/lang/Float;";
    public static final String BOX_DOUBLE_DESC = "(D)Ljava/lang/Double;";
    public static final String BOOLEAN_VALUE = "booleanValue";
    public static final String CHAR_VALUE = "charValue";
    public static final String BYTE_VALUE = "byteValue";
    public static final String SHORT_VALUE = "shortValue";
    public static final String INT_VALUE = "intValue";
    public static final String LONG_VALUE = "longValue";
    public static final String FLOAT_VALUE = "floatValue";
    public static final String DOUBLE_VALUE = "doubleValue";
    public static final String BOOLEAN_VALUE_DESC = "()Z";
    public static final String CHAR_VALUE_DESC = "()C";
    public static final String BYTE_VALUE_DESC = "()B";
    public static final String SHORT_VALUE_DESC = "()S";
    public static final String INT_VALUE_DESC = "()I";
    public static final String LONG_VALUE_DESC = "()J";
    public static final String FLOAT_VALUE_DESC = "()F";
    public static final String DOUBLE_VALUE_DESC = "()D";
    private static final ValidationResult INVALID = new ValidationResult(false);
    private static final ValidationResult ANY = new ValidationResult(true);
    private final int access;
    private final String parentClz;
    private final String superClz;
    private final String name;
    private final String desc;
    private Type returnType;
    private Type[] argumentTypes;
    private Map<Integer, Type> extraTypes;

    public MethodInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv);
        this.parentClz = parentClz;
        this.superClz = superClz;
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.returnType = Type.getReturnType(desc);
        this.argumentTypes = Type.getArgumentTypes(desc);
        this.extraTypes = new HashMap<Integer, Type>();
    }

    public int getAccess() {
        return this.access;
    }

    public final String getName() {
        return this.getName(false);
    }

    public final String getName(boolean fqn) {
        return (fqn ? this.parentClz + "." : "") + this.name + (fqn ? this.desc : "");
    }

    public final String getDescriptor() {
        return this.desc;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    protected void addExtraTypeInfo(int index, Type type) {
        if (index != -1) {
            this.extraTypes.put(index, type);
        }
    }

    protected void loadArguments(ArgumentProvider ... argumentProviders) {
        Arrays.sort(argumentProviders, new Comparator<ArgumentProvider>(){

            @Override
            public int compare(ArgumentProvider o1, ArgumentProvider o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 != null && o2 == null) {
                    return -1;
                }
                if (o2 != null && o1 == null) {
                    return 1;
                }
                if (o1.getIndex() == o2.getIndex()) {
                    return 0;
                }
                if (o1.getIndex() < o2.getIndex()) {
                    return -1;
                }
                return 1;
            }
        });
        for (ArgumentProvider provider : argumentProviders) {
            if (provider == null) continue;
            provider.provide();
        }
    }

    public void loadThis() {
        if ((this.access & 8) != 0) {
            throw new IllegalStateException("no 'this' inside static method");
        }
        super.visitVarInsn(25, 0);
    }

    public int[] backupStack(LocalVariablesSorter lvs, boolean isStatic) {
        return this.backupStack(lvs, this.argumentTypes, isStatic);
    }

    public int[] backupStack(LocalVariablesSorter lvs, Type[] methodArgTypes, boolean isStatic) {
        int[] backupArgsIndexes = new int[methodArgTypes.length + 1];
        int upper = methodArgTypes.length - 1;
        for (int i = 0; i < methodArgTypes.length; ++i) {
            int index;
            backupArgsIndexes[upper - i + 1] = index = lvs.newLocal(methodArgTypes[upper - i]);
        }
        if (!isStatic) {
            int index;
            backupArgsIndexes[0] = index = lvs.newLocal(TypeUtils.objectType);
        }
        return backupArgsIndexes;
    }

    public void restoreStack(int[] backupArgsIndexes, boolean isStatic) {
        this.restoreStack(backupArgsIndexes, this.argumentTypes, isStatic);
    }

    public void restoreStack(int[] backupArgsIndexes, Type[] methodArgTypes, boolean isStatic) {
        int upper = methodArgTypes.length - 1;
        if (!isStatic) {
            this.loadLocal(TypeUtils.objectType, backupArgsIndexes[0]);
        }
        for (int i = methodArgTypes.length - 1; i > -1; --i) {
            this.loadLocal(methodArgTypes[upper - i], backupArgsIndexes[upper - i + 1]);
        }
    }

    protected final boolean isStatic() {
        return (this.getAccess() & 8) != 0;
    }

    protected final boolean isConstructor() {
        return "<init>".equals(this.name);
    }

    public void returnValue() {
        super.visitInsn(this.returnType.getOpcode(172));
    }

    public void push(int value) {
        if (value >= -1 && value <= 5) {
            super.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            super.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            super.visitIntInsn(17, value);
        } else {
            super.visitLdcInsn(value);
        }
    }

    public void arrayLoad(Type type) {
        super.visitInsn(type.getOpcode(46));
    }

    public void arrayStore(Type type) {
        super.visitInsn(type.getOpcode(79));
    }

    public void loadLocal(Type type, int index) {
        super.visitVarInsn(type.getOpcode(21), index);
    }

    public void storeLocal(Type type, int index) {
        super.visitVarInsn(type.getOpcode(54), index);
    }

    public void pop() {
        super.visitInsn(87);
    }

    public void dup() {
        super.visitInsn(89);
    }

    public void dup2() {
        super.visitInsn(92);
    }

    public void dupArrayValue(int arrayOpcode) {
        switch (arrayOpcode) {
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.dup();
                break;
            }
            case 47: 
            case 49: 
            case 80: 
            case 82: {
                this.dup2();
            }
        }
    }

    public void dupReturnValue(int returnOpcode) {
        switch (returnOpcode) {
            case 172: 
            case 174: 
            case 176: {
                super.visitInsn(89);
                return;
            }
            case 173: 
            case 175: {
                super.visitInsn(92);
                return;
            }
            case 177: {
                return;
            }
        }
        throw new IllegalArgumentException("not return");
    }

    public void dupValue(Type type) {
        switch (type.getSize()) {
            case 1: {
                this.dup();
                break;
            }
            case 2: {
                this.dup2();
            }
        }
    }

    public void dupValue(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                super.visitInsn(89);
                break;
            }
            case 'D': 
            case 'J': {
                super.visitInsn(92);
                break;
            }
            default: {
                throw new RuntimeException("invalid signature");
            }
        }
    }

    public void box(Type type) {
        this.box(type.getDescriptor());
    }

    public void box(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                break;
            }
            case 'Z': {
                super.visitMethodInsn(184, JAVA_LANG_BOOLEAN, BOX_VALUEOF, BOX_BOOLEAN_DESC);
                break;
            }
            case 'C': {
                super.visitMethodInsn(184, JAVA_LANG_CHARACTER, BOX_VALUEOF, BOX_CHARACTER_DESC);
                break;
            }
            case 'B': {
                super.visitMethodInsn(184, JAVA_LANG_BYTE, BOX_VALUEOF, BOX_BYTE_DESC);
                break;
            }
            case 'S': {
                super.visitMethodInsn(184, JAVA_LANG_SHORT, BOX_VALUEOF, BOX_SHORT_DESC);
                break;
            }
            case 'I': {
                super.visitMethodInsn(184, JAVA_LANG_INTEGER, BOX_VALUEOF, BOX_INTEGER_DESC);
                break;
            }
            case 'J': {
                super.visitMethodInsn(184, JAVA_LANG_LONG, BOX_VALUEOF, BOX_LONG_DESC);
                break;
            }
            case 'F': {
                super.visitMethodInsn(184, JAVA_LANG_FLOAT, BOX_VALUEOF, BOX_FLOAT_DESC);
                break;
            }
            case 'D': {
                super.visitMethodInsn(184, JAVA_LANG_DOUBLE, BOX_VALUEOF, BOX_DOUBLE_DESC);
            }
        }
    }

    public void unbox(Type type) {
        this.unbox(type.getDescriptor());
    }

    public void unbox(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                super.visitTypeInsn(192, Type.getType(desc).getInternalName());
                break;
            }
            case 'Z': {
                super.visitTypeInsn(192, JAVA_LANG_BOOLEAN);
                super.visitMethodInsn(182, JAVA_LANG_BOOLEAN, BOOLEAN_VALUE, BOOLEAN_VALUE_DESC);
                break;
            }
            case 'C': {
                super.visitTypeInsn(192, JAVA_LANG_CHARACTER);
                super.visitMethodInsn(182, JAVA_LANG_CHARACTER, CHAR_VALUE, CHAR_VALUE_DESC);
                break;
            }
            case 'B': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, BYTE_VALUE, BYTE_VALUE_DESC);
                break;
            }
            case 'S': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, SHORT_VALUE, SHORT_VALUE_DESC);
                break;
            }
            case 'I': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, INT_VALUE, INT_VALUE_DESC);
                break;
            }
            case 'J': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, LONG_VALUE, LONG_VALUE_DESC);
                break;
            }
            case 'F': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, FLOAT_VALUE, FLOAT_VALUE_DESC);
                break;
            }
            case 'D': {
                super.visitTypeInsn(192, JAVA_LANG_NUMBER);
                super.visitMethodInsn(182, JAVA_LANG_NUMBER, DOUBLE_VALUE, DOUBLE_VALUE_DESC);
            }
        }
    }

    public void defaultValue(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                super.visitInsn(1);
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                super.visitInsn(3);
                break;
            }
            case 'J': {
                super.visitInsn(9);
                break;
            }
            case 'F': {
                super.visitInsn(11);
                break;
            }
            case 'D': {
                super.visitInsn(14);
            }
        }
    }

    public void println(String msg) {
        super.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        super.visitLdcInsn(msg);
        super.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V");
    }

    public void printObject() {
        super.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        super.visitInsn(95);
        super.visitMethodInsn(182, "java/io/PrintStream", "println", JAVA_LANG_THREAD_LOCAL_SET_DESC);
    }

    public void invokeVirtual(String owner, String method, String desc) {
        super.visitMethodInsn(182, owner, method, desc);
    }

    public void invokeSpecial(String owner, String method, String desc) {
        super.visitMethodInsn(183, owner, method, desc);
    }

    public void invokeStatic(String owner, String method, String desc) {
        super.visitMethodInsn(184, owner, method, desc);
    }

    protected String getParentClz() {
        return this.parentClz;
    }

    protected String getSuperClz() {
        return this.superClz;
    }

    protected ValidationResult validateArguments(OnMethod om, boolean staticFlag, Type[] actionArgTypes, Type[] methodArgTypes) {
        int specialArgsCount = 0;
        if (om.getSelfParameter() != -1) {
            if (staticFlag) {
                return INVALID;
            }
            Type selfType = this.extraTypes.get(om.getSelfParameter());
            if (selfType == null && !TypeUtils.isObject(actionArgTypes[om.getSelfParameter()]) || selfType != null && !TypeUtils.isCompatible(actionArgTypes[om.getSelfParameter()], selfType)) {
                System.err.println("Invalid @Self parameter. Expected " + selfType + ", Received " + actionArgTypes[om.getSelfParameter()]);
                return INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getReturnParameter() != -1) {
            Type type = this.extraTypes.get(om.getReturnParameter());
            if (type == null) {
                type = this.returnType;
            }
            if (type == null || !TypeUtils.isObject(actionArgTypes[om.getReturnParameter()]) && !TypeUtils.isCompatible(actionArgTypes[om.getReturnParameter()], type)) {
                System.err.println("Invalid @Return parameter. Expected '" + this.returnType + ", received " + actionArgTypes[om.getReturnParameter()]);
                return INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getTargetMethodOrFieldParameter() != -1) {
            if (!TypeUtils.isCompatible(actionArgTypes[om.getTargetMethodOrFieldParameter()], Type.getType(String.class))) {
                System.err.println("Invalid @CalledMethod parameter. Expected " + Type.getType(String.class) + ", received " + actionArgTypes[om.getTargetMethodOrFieldParameter()]);
                return INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getTargetInstanceParameter() != -1) {
            Type calledType = this.extraTypes.get(om.getTargetInstanceParameter());
            if (calledType == null && !TypeUtils.isObject(actionArgTypes[om.getTargetInstanceParameter()]) || calledType != null && !TypeUtils.isCompatible(actionArgTypes[om.getTargetInstanceParameter()], calledType)) {
                System.err.println("Invalid @CalledInstance parameter. Expected " + Type.getType(Object.class) + ", received " + actionArgTypes[om.getTargetInstanceParameter()]);
                return INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getDurationParameter() != -1) {
            if (actionArgTypes[om.getDurationParameter()] != Type.LONG_TYPE) {
                return INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getClassNameParameter() != -1) {
            if (!TypeUtils.isCompatible(actionArgTypes[om.getClassNameParameter()], Type.getType(String.class))) {
                return INVALID;
            }
            ++specialArgsCount;
        }
        if (om.getMethodParameter() != -1) {
            if (!TypeUtils.isCompatible(actionArgTypes[om.getMethodParameter()], Type.getType(String.class))) {
                return INVALID;
            }
            ++specialArgsCount;
        }
        Type[] cleansedArgArray = new Type[actionArgTypes.length - specialArgsCount];
        int[] cleansedArgIndex = new int[cleansedArgArray.length];
        int counter = 0;
        for (int argIndex = 0; argIndex < actionArgTypes.length; ++argIndex) {
            if (argIndex == om.getSelfParameter() || argIndex == om.getClassNameParameter() || argIndex == om.getMethodParameter() || argIndex == om.getReturnParameter() || argIndex == om.getTargetInstanceParameter() || argIndex == om.getTargetMethodOrFieldParameter() || argIndex == om.getDurationParameter()) continue;
            cleansedArgArray[counter] = actionArgTypes[argIndex];
            cleansedArgIndex[counter] = argIndex;
            ++counter;
        }
        if (cleansedArgArray.length == 0) {
            return ANY;
        }
        if (cleansedArgArray.length > 0 && !TypeUtils.isAnyTypeArray(cleansedArgArray[0]) && !TypeUtils.isCompatible(cleansedArgArray, methodArgTypes)) {
            return INVALID;
        }
        return new ValidationResult(true, cleansedArgIndex);
    }

    private int getArgumentIndex(int arg) {
        int index = (this.access & 8) == 0 ? 1 : 0;
        for (int i = 0; i < arg; ++i) {
            index += this.argumentTypes[i].getSize();
        }
        return index;
    }

    protected class AnyTypeArgProvider
    extends ArgumentProvider {
        private int argPtr;

        public AnyTypeArgProvider(int index, int basePtr) {
            super(index);
            this.argPtr = basePtr;
        }

        @Override
        public void doProvide() {
            MethodInstrumentor.this.push(MethodInstrumentor.this.argumentTypes.length);
            MethodInstrumentor.this.visitTypeInsn(189, TypeUtils.objectType.getInternalName());
            for (int j = 0; j < MethodInstrumentor.this.argumentTypes.length; ++j) {
                MethodInstrumentor.this.dup();
                MethodInstrumentor.this.push(j);
                Type argType = MethodInstrumentor.this.argumentTypes[j];
                MethodInstrumentor.this.loadLocal(argType, this.argPtr);
                MethodInstrumentor.this.box(argType);
                MethodInstrumentor.this.arrayStore(TypeUtils.objectType);
                this.argPtr += argType.getSize();
            }
        }
    }

    protected abstract class ArgumentProvider {
        private int index;

        public ArgumentProvider(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public final void provide() {
            if (this.index > -1) {
                this.doProvide();
            }
        }

        protected abstract void doProvide();
    }

    protected class ConstantArgProvider
    extends ArgumentProvider {
        private Object constant;

        public ConstantArgProvider(int index, Object constant) {
            super(index);
            this.constant = constant;
        }

        @Override
        public void doProvide() {
            MethodInstrumentor.this.visitLdcInsn(this.constant);
        }

        public String toString() {
            return "Constant " + this.constant + " (@" + this.getIndex() + ")";
        }
    }

    protected class LocalVarArgProvider
    extends ArgumentProvider {
        private Type type;
        private int ptr;

        public LocalVarArgProvider(int index, Type type, int ptr) {
            super(index);
            this.type = type;
            this.ptr = ptr;
        }

        @Override
        public void doProvide() {
            MethodInstrumentor.this.loadLocal(this.type, this.ptr);
        }

        public String toString() {
            return "LocalVar #" + this.ptr + " of type " + this.type + " (@" + this.getIndex() + ")";
        }
    }

    protected static final class ValidationResult {
        private static final int[] EMPTY_ARRAY = new int[0];
        private final boolean isValid;
        private final int[] argsIndex;

        public ValidationResult(boolean valid, int[] argsIndex) {
            this.isValid = valid;
            this.argsIndex = argsIndex;
        }

        public ValidationResult(boolean valid) {
            this(valid, EMPTY_ARRAY);
        }

        public int getArgIdx(int ptr) {
            return ptr > -1 && ptr < this.argsIndex.length ? this.argsIndex[ptr] : -1;
        }

        public int getArgCnt() {
            return this.argsIndex.length;
        }

        public boolean isAny() {
            return this.argsIndex.length == 0;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidationResult other = (ValidationResult)obj;
            if (this.isValid != other.isValid) {
                return false;
            }
            return Arrays.equals(this.argsIndex, other.argsIndex);
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + (this.isValid ? 1 : 0);
            hash = 59 * hash + Arrays.hashCode(this.argsIndex);
            return hash;
        }
    }
}

