/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.AnnotationVisitor;
import com.sun.btrace.org.objectweb.asm.Attribute;
import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassVisitor;
import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.Constants;
import com.sun.btrace.util.NullVisitor;

public class MethodRemover
extends ClassAdapter {
    public MethodRemover(ClassVisitor visitor) {
        super(visitor);
    }

    private MethodVisitor addMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public MethodVisitor visitMethod(final int access, final String name, final String desc, final String signature, final String[] exceptions) {
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        return new MethodAdapter(new NullVisitor()){
            private boolean include;
            private MethodVisitor adaptee;
            {
                super(x0);
                this.include = true;
                this.adaptee = null;
            }

            private MethodVisitor getAdaptee() {
                if (this.include && this.adaptee == null) {
                    this.adaptee = MethodRemover.this.addMethod(access, name, desc, signature, exceptions);
                }
                return this.adaptee;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String annoDesc, boolean visible) {
                if (annoDesc.equals(Constants.ONMETHOD_DESC)) {
                    this.include = false;
                    return new NullVisitor();
                }
                if (annoDesc.equals(Constants.ONPROBE_DESC)) {
                    this.include = false;
                    return new NullVisitor();
                }
                return this.getAdaptee().visitAnnotation(annoDesc, visible);
            }

            @Override
            public void visitAttribute(Attribute attr) {
                if (this.include) {
                    this.getAdaptee().visitAttribute(attr);
                }
            }

            @Override
            public void visitCode() {
                if (this.include) {
                    this.getAdaptee().visitCode();
                }
            }

            @Override
            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                if (this.include) {
                    this.getAdaptee().visitFrame(type, nLocal, local, nStack, stack);
                }
            }

            @Override
            public void visitInsn(int opcode) {
                if (this.include) {
                    this.getAdaptee().visitInsn(opcode);
                }
            }

            @Override
            public void visitIntInsn(int opcode, int operand) {
                if (this.include) {
                    this.getAdaptee().visitIntInsn(opcode, operand);
                }
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                if (this.include) {
                    this.getAdaptee().visitVarInsn(opcode, var);
                }
            }

            @Override
            public void visitTypeInsn(int opcode, String desc2) {
                if (this.include) {
                    this.getAdaptee().visitTypeInsn(opcode, desc2);
                }
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name2, String desc2) {
                if (this.include) {
                    this.getAdaptee().visitFieldInsn(opcode, owner, name2, desc2);
                }
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name2, String desc2) {
                if (this.include) {
                    this.getAdaptee().visitMethodInsn(opcode, owner, name2, desc2);
                }
            }

            @Override
            public void visitJumpInsn(int opcode, Label label) {
                if (this.include) {
                    this.getAdaptee().visitJumpInsn(opcode, label);
                }
            }

            @Override
            public void visitLabel(Label label) {
                if (this.include) {
                    this.getAdaptee().visitLabel(label);
                }
            }

            @Override
            public void visitLdcInsn(Object cst) {
                if (this.include) {
                    this.getAdaptee().visitLdcInsn(cst);
                }
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                if (this.include) {
                    this.getAdaptee().visitIincInsn(var, increment);
                }
            }

            @Override
            public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
                if (this.include) {
                    this.getAdaptee().visitTableSwitchInsn(min, max, dflt, labels);
                }
            }

            @Override
            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                if (this.include) {
                    this.getAdaptee().visitLookupSwitchInsn(dflt, keys, labels);
                }
            }

            @Override
            public void visitMultiANewArrayInsn(String desc2, int dims) {
                if (this.include) {
                    this.getAdaptee().visitMultiANewArrayInsn(desc2, dims);
                }
            }

            @Override
            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                if (this.include) {
                    this.getAdaptee().visitTryCatchBlock(start, end, handler, type);
                }
            }

            @Override
            public void visitLocalVariable(String name2, String desc2, String signature2, Label start, Label end, int index) {
                if (this.include) {
                    this.getAdaptee().visitLocalVariable(name2, desc2, signature2, start, end, index);
                }
            }

            @Override
            public void visitLineNumber(int line, Label start) {
                if (this.include) {
                    this.getAdaptee().visitLineNumber(line, start);
                }
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                if (this.include) {
                    this.getAdaptee().visitMaxs(maxStack, maxLocals);
                }
            }

            @Override
            public void visitEnd() {
                if (this.include) {
                    this.getAdaptee().visitEnd();
                }
            }
        };
    }
}

