/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Type;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class MethodReturnInstrumentor
extends MethodInstrumentor {
    public MethodReturnInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitInsn(int opcode) {
        switch (opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                this.onMethodReturn(opcode);
                break;
            }
        }
        super.visitInsn(opcode);
    }

    protected void loadReturnParameter(int opcode) {
        super.dupReturnValue(opcode);
    }

    protected void onMethodReturn(int opcode) {
        this.println("leaving " + this.getName() + this.getDescriptor());
    }

    public boolean usesTimeStamp() {
        return false;
    }

    public static void main(final String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.MethodReturnInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodReturnInstrumentor(mv, args[0], args[0], access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }

    protected void loadDurationParameter(int localVarIndex1, int localVarIndex2) {
        if (localVarIndex1 != -1 && localVarIndex2 != -1) {
            super.loadLocal(Type.LONG_TYPE, localVarIndex2);
            super.loadLocal(Type.LONG_TYPE, localVarIndex1);
            super.visitInsn(101);
        }
    }
}

