/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ObjectAllocInstrumentor
extends MethodInstrumentor {
    public ObjectAllocInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        if (opcode == 187) {
            this.beforeObjectNew(desc);
        }
        super.visitTypeInsn(opcode, desc);
        if (opcode == 187) {
            this.afterObjectNew(desc);
        }
    }

    protected void beforeObjectNew(String desc) {
    }

    protected void afterObjectNew(String desc) {
    }

    public static void main(final String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.ObjectAllocInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new ObjectAllocInstrumentor(mv, args[0], args[0], access, name, desc){

                    @Override
                    protected void afterObjectNew(String desc) {
                        this.println("after allocating an object of " + desc);
                    }

                    @Override
                    protected void beforeObjectNew(String desc) {
                        this.println("before allocating an object of " + desc);
                    }
                };
            }
        });
        fos.write(writer.toByteArray());
    }
}

