/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.runtime;

import com.sun.btrace.org.objectweb.asm.ClassAdapter;
import com.sun.btrace.org.objectweb.asm.ClassReader;
import com.sun.btrace.org.objectweb.asm.ClassWriter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.runtime.InstrumentUtils;
import com.sun.btrace.runtime.MethodInstrumentor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class TypeCheckInstrumentor
extends MethodInstrumentor {
    public TypeCheckInstrumentor(MethodVisitor mv, String parentClz, String superClz, int access, String name, String desc) {
        super(mv, parentClz, superClz, access, name, desc);
    }

    @Override
    public void visitTypeInsn(int opcode, String desc) {
        boolean typeCheck;
        boolean bl = typeCheck = opcode == 192 || opcode == 193;
        if (typeCheck) {
            this.onBeforeTypeCheck(opcode, desc);
        }
        super.visitTypeInsn(opcode, desc);
        if (typeCheck) {
            this.onAfterTypeCheck(opcode, desc);
        }
    }

    protected void onBeforeTypeCheck(int opcode, String desc) {
        this.println("before type checking for " + desc);
    }

    protected void onAfterTypeCheck(int opcode, String desc) {
        this.println("after type checking for " + desc);
    }

    public static void main(final String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java com.sun.btrace.runtime.TypeCheckInstrumentor <class>");
            System.exit(1);
        }
        args[0] = args[0].replace('.', '/');
        FileInputStream fis = new FileInputStream(args[0] + ".class");
        ClassReader reader = new ClassReader(new BufferedInputStream(fis));
        FileOutputStream fos = new FileOutputStream(args[0] + ".class");
        ClassWriter writer = InstrumentUtils.newClassWriter();
        InstrumentUtils.accept(reader, new ClassAdapter(writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new TypeCheckInstrumentor(mv, args[0], args[0], access, name, desc);
            }
        });
        fos.write(writer.toByteArray());
    }
}

