/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.util;

import com.sun.btrace.org.objectweb.asm.Label;
import com.sun.btrace.org.objectweb.asm.MethodAdapter;
import com.sun.btrace.org.objectweb.asm.MethodVisitor;
import com.sun.btrace.org.objectweb.asm.Opcodes;
import com.sun.btrace.org.objectweb.asm.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LocalVariablesSorter
extends MethodAdapter {
    private static final Type OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    private Memento memento = new Memento();
    private boolean frozen = false;
    private Set<Integer> newLocalIndices = new HashSet<Integer>();
    private Map<Integer, Type> localVarTypeMap = new HashMap<Integer, Type>();

    public LocalVariablesSorter(int access, String desc, MethodVisitor mv, Memento memento) {
        super(mv);
        this.memento = memento;
        Type[] args = Type.getArgumentTypes(desc);
        memento.nextLocal = (8 & access) == 0 ? 1 : 0;
        for (int i = 0; i < args.length; ++i) {
            memento.nextLocal += args[i].getSize();
        }
        memento.firstLocal = memento.nextLocal;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        Type type;
        switch (opcode) {
            case 22: 
            case 55: {
                type = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type = Type.INT_TYPE;
                break;
            }
            case 25: 
            case 58: {
                type = OBJECT_TYPE;
                break;
            }
            case 169: {
                type = this.localVarTypeMap.get(var);
                type = type != null ? type : Type.VOID_TYPE;
                break;
            }
            default: {
                type = Type.VOID_TYPE;
            }
        }
        if (opcode == 55 || opcode == 54 || opcode == 56 || opcode == 57 || opcode == 58) {
            this.localVarTypeMap.put(var, type);
        }
        this.mv.visitVarInsn(opcode, this.remap(var, type));
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, Type.INT_TYPE), increment);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, this.memento.nextLocal);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        int newIndex = this.remap(index, Type.getType(desc));
        this.mv.visitLocalVariable(name, desc, signature, start, end, newIndex);
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        int number;
        if (type != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (!this.memento.changed) {
            this.mv.visitFrame(type, nLocal, local, nStack, stack);
            return;
        }
        Object[] oldLocals = new Object[this.memento.newLocals.length];
        System.arraycopy(this.memento.newLocals, 0, oldLocals, 0, oldLocals.length);
        int index = 0;
        for (number = 0; number < nLocal; ++number) {
            int size;
            Object t = local[number];
            int n = size = t == Opcodes.LONG || t == Opcodes.DOUBLE ? 2 : 1;
            if (t != Opcodes.TOP) {
                this.setFrameLocal(this.remap(index, size), t);
            }
            index += size;
        }
        index = 0;
        number = 0;
        int i = 0;
        while (index < this.memento.newLocals.length) {
            Object t = this.memento.newLocals[index++];
            if (t != null && t != Opcodes.TOP) {
                ((Memento)this.memento).newLocals[i] = t;
                number = i + 1;
                if (t == Opcodes.LONG || t == Opcodes.DOUBLE) {
                    ++index;
                }
            } else {
                ((Memento)this.memento).newLocals[i] = Opcodes.TOP;
            }
            ++i;
        }
        this.mv.visitFrame(type, number, this.memento.newLocals, nStack, stack);
        Memento.access$302(this.memento, oldLocals);
    }

    public int newLocal(Type type) {
        Object t;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                t = Opcodes.INTEGER;
                break;
            }
            case 6: {
                t = Opcodes.FLOAT;
                break;
            }
            case 7: {
                t = Opcodes.LONG;
                break;
            }
            case 8: {
                t = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                t = type.getDescriptor();
                break;
            }
            default: {
                t = type.getInternalName();
            }
        }
        int local = this.getNextLocal();
        this.memento.nextLocal += type.getSize();
        this.setLocalType(local, type);
        this.setFrameLocal(local, t);
        this.mv.visitVarInsn(type.getOpcode(54), local);
        this.newLocalIndices.add(local);
        return local;
    }

    public void freeze() {
        this.frozen = true;
    }

    public void unfreeze() {
        this.frozen = false;
    }

    public int getFirstLocal() {
        return this.memento.firstLocal;
    }

    public int getNextLocal() {
        return this.memento.nextLocal;
    }

    protected void setLocalType(int local, Type type) {
    }

    private void setFrameLocal(int local, Object type) {
        int l = this.memento.newLocals.length;
        if (local >= l) {
            Object[] a = new Object[Math.max(2 * l, local + 1)];
            System.arraycopy(this.memento.newLocals, 0, a, 0, l);
            Memento.access$302(this.memento, a);
        }
        ((Memento)this.memento).newLocals[local] = type;
    }

    public int remap(int var, Type type) {
        int value;
        int size;
        if (this.frozen) {
            return var;
        }
        if (var < this.getFirstLocal()) {
            return var;
        }
        int key = 2 * var + type.getSize() - 1;
        if (key >= (size = this.memento.mapping.length)) {
            int[] newMapping = new int[Math.max(2 * size, key + 1)];
            System.arraycopy(this.memento.mapping, 0, newMapping, 0, size);
            Memento.access$402(this.memento, newMapping);
        }
        if ((value = this.memento.mapping[key]) == 0) {
            value = this.newLocalMapping(type);
            this.setLocalType(value, type);
            ((Memento)this.memento).mapping[key] = value + 1;
        } else {
            --value;
        }
        if (value != var) {
            this.memento.changed = true;
        }
        return value;
    }

    protected int newLocalMapping(Type type) {
        int local = this.getNextLocal();
        this.memento.nextLocal += type.getSize();
        return local;
    }

    private int remap(int var, int size) {
        int value;
        if (this.frozen) {
            return var;
        }
        if (var < this.getFirstLocal()) {
            return var;
        }
        int key = 2 * var + size - 1;
        int n = value = key < this.memento.mapping.length ? this.memento.mapping[key] : 0;
        if (value == 0) {
            throw new IllegalStateException("Unknown local variable " + var);
        }
        return value - 1;
    }

    public static class Memento {
        private int firstLocal;
        private int nextLocal;
        private int[] mapping = new int[40];
        private Object[] newLocals = new Object[20];
        private boolean changed;

        static /* synthetic */ Object[] access$302(Memento x0, Object[] x1) {
            x0.newLocals = x1;
            return x1;
        }

        static /* synthetic */ int[] access$402(Memento x0, int[] x1) {
            x0.mapping = x1;
            return x1;
        }
    }
}

