/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceHelper {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final Pattern LIBRARY_VERSION_PATTERN = Pattern.compile("^(\\d+)(_\\d+)+");
    private static final Pattern RESOURCE_VERSION_PATTERN = Pattern.compile("^((?:\\d+)(?:_\\d+)+)[\\.]?(\\w+)?");
    private static final String COMPRESSED_CONTENT_FILENAME = "compressed-content";

    public abstract String getBaseResourcePath();

    public InputStream getInputStream(ResourceInfo resource, FacesContext ctx) throws IOException {
        InputStream in = null;
        if (resource.isCompressable() && this.clientAcceptsCompression(ctx)) {
            try {
                String path = resource.getCompressedPath();
                in = new BufferedInputStream(new FileInputStream(path + File.separatorChar + COMPRESSED_CONTENT_FILENAME));
            }
            catch (IOException ioe) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
                }
                in = null;
            }
        }
        if (in == null) {
            in = this.getNonCompressedInputStream(resource, ctx);
        }
        return in;
    }

    public abstract URL getURL(ResourceInfo var1, FacesContext var2);

    public abstract LibraryInfo findLibrary(String var1, String var2, FacesContext var3);

    public abstract ResourceInfo findResource(LibraryInfo var1, String var2, String var3, boolean var4, FacesContext var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(ResourceInfo resource, FacesContext ctx) {
        long ret;
        URL url = this.getURL(resource, ctx);
        if (url == null) {
            return 0L;
        }
        InputStream input = null;
        try {
            URLConnection con = url.openConnection();
            con.setUseCaches(false);
            con.connect();
            input = con.getInputStream();
            ret = con.getLastModified();
        }
        catch (IOException ioe) {
            ret = 0L;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignored) {}
            }
        }
        return ret >= 0L ? ret : 0L;
    }

    protected abstract InputStream getNonCompressedInputStream(ResourceInfo var1, FacesContext var2) throws IOException;

    protected VersionInfo getVersion(Collection<String> resourcePaths, boolean isResource) {
        ArrayList<VersionInfo> versionedPaths = new ArrayList<VersionInfo>(resourcePaths.size());
        for (String p : resourcePaths) {
            VersionInfo vp = this.getVersion(p, isResource);
            if (vp == null) continue;
            versionedPaths.add(vp);
        }
        VersionInfo version = null;
        if (!versionedPaths.isEmpty()) {
            Collections.sort(versionedPaths);
            version = (VersionInfo)versionedPaths.get(versionedPaths.size() - 1);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compressContent(ResourceInfo info) throws IOException {
        InputStream source = null;
        OutputStream dest = null;
        try {
            URL url = info.getHelper().getURL(info, FacesContext.getCurrentInstance());
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.connect();
            source = conn.getInputStream();
            byte[] buf = new byte[512];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dest = new GZIPOutputStream(baos);
            int totalRead = 0;
            int len = source.read(buf);
            while (len != -1) {
                dest.write(buf, 0, len);
                totalRead += len;
                len = source.read(buf);
            }
            dest.flush();
            try {
                dest.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            if (baos.size() < totalRead) {
                String outputFile = info.getCompressedPath() + File.separatorChar + COMPRESSED_CONTENT_FILENAME;
                dest = new FileOutputStream(outputFile);
                dest.write(baos.toByteArray());
                dest.flush();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException ignored) {}
            }
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    protected boolean clientAcceptsCompression(FacesContext ctx) {
        ExternalContext extCtx = ctx.getExternalContext();
        Object response = extCtx.getResponse();
        if (response instanceof HttpServletResponse) {
            String[] values = (String[])extCtx.getRequestHeaderValuesMap().get("accept-encoding");
            boolean gzipFound = false;
            for (String value : values) {
                if (value.contains("gzip;q=0")) {
                    return false;
                }
                if (value.contains("gzip")) {
                    gzipFound = true;
                    break;
                }
                if (!value.contains("*") || value.contains("*;q=0,") || value.endsWith("*;q=0")) continue;
                gzipFound = true;
            }
            if (gzipFound) {
                ((HttpServletResponse)response).setHeader("Content-Encoding", "gzip");
                return true;
            }
        }
        return false;
    }

    protected ResourceInfo handleCompression(ResourceInfo resource) {
        try {
            if (!this.compressContent(resource)) {
                resource = this.rebuildAsNonCompressed(resource);
            }
        }
        catch (IOException ioe) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
            }
            resource = this.rebuildAsNonCompressed(resource);
        }
        return resource;
    }

    private ResourceInfo rebuildAsNonCompressed(ResourceInfo resource) {
        LibraryInfo library = resource.getLibraryInfo();
        ResourceInfo ret = library != null ? new ResourceInfo(resource.getLibraryInfo(), resource.getName(), resource.getVersion(), false) : new ResourceInfo(resource.getName(), resource.getVersion(), resource.getLocalePrefix(), this, false);
        return ret;
    }

    private VersionInfo getVersion(String pathElement, boolean isResource) {
        String[] pathElements = Util.split(pathElement, "/");
        String path = pathElements[pathElements.length - 1];
        String extension = null;
        if (isResource) {
            Matcher m = RESOURCE_VERSION_PATTERN.matcher(path);
            return m.matches() ? new VersionInfo(m.group(1), m.group(2)) : null;
        }
        return LIBRARY_VERSION_PATTERN.matcher(path).matches() ? new VersionInfo(path, extension) : null;
    }
}

