/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.MenuRenderer;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class SelectManyCheckboxListRenderer
extends MenuRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTMANYCHECKBOX);

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Object borderObj;
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        boolean alignVertical = false;
        int border = 0;
        String alignStr = (String)component.getAttributes().get("layout");
        if (null != alignStr) {
            alignVertical = alignStr.equalsIgnoreCase("pageDirection");
        }
        if (null != (borderObj = component.getAttributes().get("border"))) {
            border = (Integer)borderObj;
        }
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        this.renderBeginText(component, border, alignVertical, context, true);
        Iterator<SelectItem> items = RenderKitUtils.getSelectItems(context, component);
        Object currentSelections = this.getCurrentSelectedValues(component);
        Object[] submittedValues = this.getSubmittedSelectedValues(component);
        Map attributes = component.getAttributes();
        HtmlBasicRenderer.OptionComponentInfo optionInfo = new HtmlBasicRenderer.OptionComponentInfo((String)attributes.get("disabledClass"), (String)attributes.get("enabledClass"), (String)attributes.get("unselectedClass"), (String)attributes.get("selectedClass"), Util.componentIsDisabled(component));
        int idx = -1;
        while (items.hasNext()) {
            SelectItem curItem = items.next();
            ++idx;
            if (curItem instanceof SelectItemGroup) {
                if (curItem.getLabel() != null) {
                    if (alignVertical) {
                        writer.startElement("tr", component);
                    }
                    writer.startElement("td", component);
                    writer.writeText((Object)curItem.getLabel(), component, "label");
                    writer.endElement("td");
                    if (alignVertical) {
                        writer.endElement("tr");
                    }
                }
                if (alignVertical) {
                    writer.startElement("tr", component);
                }
                writer.startElement("td", component);
                writer.writeText((Object)"\n", component, null);
                this.renderBeginText(component, 0, alignVertical, context, false);
                SelectItem[] itemsArray = ((SelectItemGroup)curItem).getSelectItems();
                for (int i = 0; i < itemsArray.length; ++i) {
                    this.renderOption(context, component, converter, itemsArray[i], currentSelections, submittedValues, alignVertical, i, optionInfo);
                }
                this.renderEndText(component, alignVertical, context);
                writer.endElement("td");
                if (!alignVertical) continue;
                writer.endElement("tr");
                writer.writeText((Object)"\n", component, null);
                continue;
            }
            this.renderOption(context, component, converter, curItem, currentSelections, submittedValues, alignVertical, idx, optionInfo);
        }
        this.renderEndText(component, alignVertical, context);
    }

    protected void renderBeginText(UIComponent component, int border, boolean alignVertical, FacesContext context, boolean outerTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("table", component);
        if (border != Integer.MIN_VALUE) {
            writer.writeAttribute("border", (Object)border, "border");
        }
        if (outerTable) {
            if (this.shouldWriteIdAttribute(component)) {
                this.writeIdAttributeIfNecessary(context, writer, component);
            }
            String styleClass = (String)component.getAttributes().get("styleClass");
            String style = (String)component.getAttributes().get("style");
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "class");
            }
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
        }
        writer.writeText((Object)"\n", component, null);
        if (!alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.startElement("tr", component);
            writer.writeText((Object)"\n", component, null);
        }
    }

    protected void renderEndText(UIComponent component, boolean alignVertical, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (!alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        writer.endElement("table");
    }

    protected void renderOption(FacesContext context, UIComponent component, Converter converter, SelectItem curItem, Object currentSelections, Object[] submittedValues, boolean alignVertical, int itemNumber, HtmlBasicRenderer.OptionComponentInfo optionInfo) throws IOException {
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.startElement("tr", component);
            writer.writeText((Object)"\n", component, null);
        }
        writer.startElement("td", component);
        writer.writeText((Object)"\n", component, null);
        writer.startElement("input", component);
        writer.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        String idString = component.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + Integer.toString(itemNumber);
        writer.writeAttribute("id", (Object)idString, "id");
        String valueString = this.getFormattedValue(context, component, curItem.getValue(), converter);
        writer.writeAttribute("value", (Object)valueString, "value");
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = valueString;
        } else {
            valuesArray = currentSelections;
            itemValue = curItem.getValue();
        }
        RequestStateManager.set(context, "com.sun.faces.ComponentForValue", component);
        if (this.isSelected(context, component, itemValue, valuesArray, converter)) {
            writer.writeAttribute(this.getSelectedTextString(), (Object)Boolean.TRUE, null);
        }
        if (!optionInfo.isDisabled() && curItem.isDisabled()) {
            writer.writeAttribute("disabled", (Object)true, "disabled");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, ATTRIBUTES, SelectManyCheckboxListRenderer.getNonOnChangeBehaviors(component));
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component);
        RenderKitUtils.renderOnchange(context, component, true);
        writer.endElement("input");
        writer.startElement("label", component);
        writer.writeAttribute("for", (Object)idString, "for");
        StringBuilder labelClass = new StringBuilder();
        String style = optionInfo.isDisabled() || curItem.isDisabled() ? optionInfo.getDisabledClass() : optionInfo.getEnabledClass();
        if (style != null) {
            labelClass.append(style);
        }
        if ((style = this.isSelected(context, component, itemValue, valuesArray, converter) ? optionInfo.getSelectedClass() : optionInfo.getUnselectedClass()) != null) {
            if (labelClass.length() > 0) {
                labelClass.append(' ');
            }
            labelClass.append(style);
        }
        writer.writeAttribute("class", (Object)labelClass.toString(), "labelClass");
        String itemLabel = curItem.getLabel();
        if (itemLabel == null) {
            itemLabel = valueString;
        }
        writer.writeText((Object)" ", component, null);
        if (!curItem.isEscape()) {
            writer.write(itemLabel);
        } else {
            writer.writeText((Object)itemLabel, component, "label");
        }
        if (this.isSelected(context, component, itemValue, valuesArray, converter)) {
            // empty if block
        }
        writer.endElement("label");
        writer.endElement("td");
        writer.writeText((Object)"\n", component, null);
        if (alignVertical) {
            writer.writeText((Object)"\t", component, null);
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
    }

    String getSelectedTextString() {
        return "checked";
    }
}

