/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.perfdata.monitor.AbstractPerfDataBuffer;
import sun.jvmstat.perfdata.monitor.protocol.local.PerfDataFile;
import sun.misc.Perf;

public class PerfDataBuffer
extends AbstractPerfDataBuffer {
    private static final Perf perf = (Perf)AccessController.doPrivileged(new Perf.GetPerfAction());

    public PerfDataBuffer(VmIdentifier vmIdentifier) throws MonitorException {
        try {
            ByteBuffer byteBuffer = perf.attach(vmIdentifier.getLocalVmId(), vmIdentifier.getMode());
            this.createPerfDataBuffer(byteBuffer, vmIdentifier.getLocalVmId());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                String string = PerfDataFile.getTempDirectory() + "hsperfdata_" + Integer.toString(vmIdentifier.getLocalVmId());
                File file = new File(string);
                FileChannel fileChannel = new RandomAccessFile(file, "r").getChannel();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fileChannel.size());
                fileChannel.close();
                this.createPerfDataBuffer(mappedByteBuffer, vmIdentifier.getLocalVmId());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new MonitorException(vmIdentifier.getLocalVmId() + " not found", illegalArgumentException);
            }
            catch (IOException iOException) {
                throw new MonitorException("Could not map 1.4.1 file for " + vmIdentifier.getLocalVmId(), iOException);
            }
        }
        catch (IOException iOException) {
            throw new MonitorException("Could not attach to " + vmIdentifier.getLocalVmId(), iOException);
        }
    }
}

