/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javap.oldjavap;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.tools.java.BinaryClass;
import sun.tools.java.ClassDeclaration;
import sun.tools.java.ClassFile;
import sun.tools.java.ClassPath;
import sun.tools.java.Constants;
import sun.tools.java.Environment;
import sun.tools.java.Identifier;
import sun.tools.java.Package;
import sun.tools.java.Type;
import sun.tools.util.ModifierFilter;

class JavaPEnvironment
extends Environment
implements Constants {
    int flags = 0;
    ClassPath sourcePath = new ClassPath("");
    ClassPath binaryPath;
    Hashtable packages = new Hashtable(31);
    Hashtable classes = new Hashtable(351);
    boolean showLineAndLocal = false;
    ModifierFilter showAccess = new ModifierFilter(-9223372036854775803L);
    boolean showDisassembled = false;
    boolean showBackwardCompatible = false;
    boolean showVerbose = false;
    boolean showInternalSigs = false;
    PrintWriter output;

    JavaPEnvironment(PrintWriter printWriter) {
        this.output = printWriter;
    }

    protected int loadFileFlags() {
        return 6;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean classExists(Identifier identifier) {
        if (identifier.isInner()) {
            identifier = identifier.getTopName();
        }
        Type type = Type.tClass(identifier);
        try {
            ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
            if (classDeclaration == null) {
                Identifier identifier2;
                Package package_ = this.getPackage(identifier.getQualifier());
                ClassFile classFile = package_.getBinaryFile(identifier2 = identifier.getName());
                return classFile != null;
            }
            return classDeclaration.getName().equals(identifier);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ClassDeclaration getClassDeclaration(Identifier identifier) {
        return this.getClassDeclaration(Type.tClass(identifier));
    }

    public ClassDeclaration getClassDeclaration(Type type) {
        ClassDeclaration classDeclaration = (ClassDeclaration)this.classes.get(type);
        if (classDeclaration == null) {
            classDeclaration = new ClassDeclaration(type.getClassName());
            this.classes.put(type, classDeclaration);
        }
        return classDeclaration;
    }

    public Package getPackage(Identifier identifier) throws IOException {
        Package package_ = (Package)this.packages.get(identifier);
        if (package_ == null) {
            package_ = new Package(this.sourcePath, this.binaryPath, identifier);
            this.packages.put(identifier, package_);
        }
        return package_;
    }

    BinaryClass loadFile(ClassFile classFile) throws IOException {
        long l = System.currentTimeMillis();
        InputStream inputStream = classFile.getInputStream();
        BinaryClass binaryClass = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            binaryClass = BinaryClass.load(new Environment(this, classFile), dataInputStream, this.loadFileFlags());
        }
        catch (ClassFormatError classFormatError) {
            throw new IllegalArgumentException("Error: bad class format" + classFile.getPath() + classFormatError.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        inputStream.close();
        return binaryClass;
    }

    public void loadDefinition(ClassDeclaration classDeclaration) {
        switch (classDeclaration.getStatus()) {
            case 0: {
                Package package_;
                Identifier identifier = classDeclaration.getName();
                try {
                    package_ = this.getPackage(identifier.getQualifier());
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error: I/O Exception - " + iOException.getMessage());
                }
                ClassFile classFile = package_.getBinaryFile(identifier.getName());
                if (classFile == null) {
                    throw new IllegalArgumentException("Error: No binary file '" + identifier.getName() + "'");
                }
                BinaryClass binaryClass = null;
                try {
                    binaryClass = this.loadFile(classFile);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Error: I/O Exception - " + iOException.getMessage() + " in " + classFile);
                }
                if (binaryClass == null) {
                    throw new IllegalArgumentException("Error: Class not found in '" + classFile + "'");
                }
                if (!binaryClass.getName().equals(identifier)) {
                    throw new IllegalArgumentException("Error: Binary file '" + identifier.getName() + "'  contains " + binaryClass.getName());
                }
                classDeclaration.setDefinition(binaryClass, 2);
                binaryClass.loadNested(this, this.loadFileFlags());
                return;
            }
        }
        throw new IllegalArgumentException("Error: No binary file");
    }

    void setPath(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null && (string = System.getProperty("env.class.path")) == null) {
            string = ".";
        }
        if (string2 == null && (string2 = System.getProperty("sun.boot.class.path")) == null) {
            string2 = "";
        }
        JavaPEnvironment.appendPath(stringBuffer, string2);
        if (string3 == null) {
            string3 = System.getProperty("java.ext.dirs");
        }
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                File file = new File(string4);
                if (!string4.endsWith(File.separator)) {
                    string4 = string4 + File.separator;
                }
                if (!file.isDirectory()) continue;
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5 = stringArray[i];
                    if (!string5.endsWith(".jar")) continue;
                    JavaPEnvironment.appendPath(stringBuffer, string4 + string5);
                }
            }
        }
        JavaPEnvironment.appendPath(stringBuffer, string);
        this.binaryPath = new ClassPath(stringBuffer.toString());
    }

    private static void appendPath(StringBuffer stringBuffer, String string) {
        if (string.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparator);
            }
            stringBuffer.append(string);
        }
    }
}

