/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * This optional variable contains config properties to initialize the 
 * environment. For example:
 * <p><code><pre>
 * woodstock4_3Config = {
 *   // Ajax config properties.
 *   ajax: {
 *       // Flag allowing Ajax resources to be lazily loaded when the webuiAjax
 *       // property is false.
 *       isAjax: true,
 *       // Flag allowing JSF Extensions to be loaded in page. If the webuiAjax 
 *       // property is true, resources are loaded immediately. Otherwise, 
 *       // resources are lazily loaded.
 *       isJsfx: true,
 *       // Ajax module.
 *       module: "woodstock4_3.widget._xhr",
 *       // Ajax module path.
 *       module: "/example/resources/woodstock4_3/suntheme/javascript/widget/_xhr",
 *       // URL used for Ajax transactions. Note: Not used by JSF Extensions.
 *       url: "/example/ExampleServlet"
 *   },
 *   // Flag to enable debug mode.
 *   isDebug: false,
 *   // Flag to inlcude style sheet(s).
 *   isStyleSheet: true,
 *   // Woodstock module path -- absolute or relative to javascript directory.
 *   modulePath: "/example/resources/@JS_NS/suntheme/javascript",
 *   // Custom name space to map as woodstock4_3.
 *   namespace: "webui.suntheme",
 *   // Flag to parse HTML markup onLoad.
 *   parseOnLoad: true,
 *   // Theme config properties.
 *   theme: {
 *       // Theme bundle name.
 *       bundle: "suntheme",
 *       // An array of custom theme config properties.
 *       custom: [{
 *           /** Custom theme bundle name.
 *           bundle: "myTheme",
 *           /** Custom theme module path -- absolute or relative to javascript directory.
 *           modulePath: "/example/resources/custom"
 *       }],
 *       // Theme locale.
 *       locale: "en",
 *       // Theme module path -- absolute or relative to javascript directory.
 *       modulePath: "/example/resources/woodstock4_3/suntheme/javascript/theme",
 *       // App context.
 *       prefix: "/example/resources"
 *   }
 * };
 * </pre></code></p><p>
 * If this variable is not availble, woodstockConfig will be used. However, in a
 * portal environment, the version number must be used in order to support
 * multiple versions of Woodstock in the same page. For example, portlet 'A'
 * still uses an older version of Woodstock while portlet 'B' takes advantage of
 * new features in the latest release. In this case, the same cofig properties
 * may not apply to both Woodstock JavaScript libraries.
 * </p>
 * @name woodstock4_3Config
 */

// Initialize the woodstock4_3Config variable.
if (typeof woodstock4_3Config == "undefined") {
    this.woodstock4_3Config = (typeof woodstockConfig != "undefined")
        ? woodstockConfig : {};
}

/**
 * @class This class contains config properties to initialize the environment.
 * Properties shall be ovrridden by the global woodstock4_3Config variable.
 * @static
 * @private
 */
woodstock4_3._base.config = {
    /** Ajax config properties. */
    ajax: {
        /**
         * Flag allowing Ajax resources to be lazily loaded when the webuiAjax
         * property is false.
         */
        isAjax: (woodstock4_3Config.ajax && woodstock4_3Config.ajax.isAjax != null)
            ? woodstock4_3Config.ajax.isAjax : true,
        /**
         * Flag allowing JSF Extensions to be loaded in page. If the webuiAjax 
         * property is true, resources are loaded immediately. Otherwise, 
         * resources are lazily loaded.
         */
        isJsfx: woodstock4_3._base.bootstrap._getBooleanParameter("jsfx",
            (woodstock4_3Config.ajax && woodstock4_3Config.ajax.isJsfx != null) 
                ? woodstock4_3Config.ajax.isJsfx : true),
        /** Ajax module. */
        module: (woodstock4_3Config.ajax && woodstock4_3Config.ajax.module)
            ? woodstock4_3Config.ajax.module : "woodstock4_3.widget._xhr",
        /** Ajax module path -- absolute or relative to javascript directory. */
        modulePath: (woodstock4_3Config.ajax && woodstock4_3Config.ajax.modulePath)
            ? woodstock4_3Config.ajax.modulePath : undefined,
        /** URL used for Ajax transactions. Note: Not used by JSF Extensions. */
        url: (woodstock4_3Config.ajax && woodstock4_3Config.ajax.url)
            ? woodstock4_3Config.ajax.url : undefined
    },
    /** Dojo config properties. */
    _djConfig: {
        /** Dojo module path. */
        baseUrl: undefined,
        /** Flag to enable dojo debug mode. */
        isDebug: false
    },
    /** 
     * The current global context. This ensures code runs correctly in contexts
     * other than web browsers (e.g., rhino).
     */
    _global: this,
    /** Flag to enable debug mode. */
    isDebug: woodstock4_3._base.bootstrap._getBooleanParameter("debug",
        (woodstock4_3Config.isDebug != null) ? woodstock4_3Config.isDebug : false),
    /** Flag to enable high contrast mode. */
    _isHighContrastMode: undefined,
    /** Flag to inlcude style sheet(s). */
    isStyleSheet: woodstock4_3._base.bootstrap._getBooleanParameter("styleSheet",
        (woodstock4_3Config.isStyleSheet != null) ? woodstock4_3Config.isStyleSheet : true),
    /** Woodstock module path -- absolute or relative to javascript directory. */
    modulePath: (woodstock4_3Config.modulePath) ? woodstock4_3Config.modulePath : ".",
    /** Custom name space to map as woodstock4_3. */
    namespace: (woodstock4_3Config.namespace) ? woodstock4_3Config.namespace : "woodstock",
    /** Flag to parse HTML markup onLoad. */
    parseOnLoad: woodstock4_3._base.bootstrap._getBooleanParameter("parseOnLoad",
        (woodstock4_3Config.parseOnLoad != null) ? woodstock4_3Config.parseOnLoad : false),
    /** Theme config properties. */
    theme: {
        /** Theme bundle name. */
        bundle: (woodstock4_3Config.theme && woodstock4_3Config.theme.bundle)
            ? woodstock4_3Config.theme.bundle : "suntheme",
        /** An array of custom theme config properties. See woodstock4_3Config. */
        custom: (woodstock4_3Config.theme && woodstock4_3Config.theme.custom)
            ? woodstock4_3Config.theme.custom : undefined,
        /** Theme locale. */
        locale: (woodstock4_3Config.theme && woodstock4_3Config.theme.locale)
            ? woodstock4_3Config.theme.locale
            : (navigator.userLanguage 
                ? navigator.userLanguage : navigator.language).toLowerCase(),
        /** Theme module path -- absolute or relative to javascript directory. */
        modulePath: (woodstock4_3Config.theme && woodstock4_3Config.theme.modulePath)
            ? woodstock4_3Config.theme.modulePath : "theme",
        /** App context. */
        prefix: (woodstock4_3Config.theme && woodstock4_3Config.theme.prefix)
            ? woodstock4_3Config.theme.prefix : undefined
    },
    /** Flag to include all widgets. NOT IMPLEMENTED */
    webuiAll: woodstock4_3._base.bootstrap._getBooleanParameter("webuiAll",
        (woodstock4_3Config.webuiAll != null) ? woodstock4_3Config.webuiAll : false),
    /**
     * Flag to include Ajax functionality. Used in conjunction with webuiAll. 
     * Note: Not used with custom Ajax implementations. NOT IMPLEMENTED
     */
    webuiAjax: woodstock4_3._base.bootstrap._getBooleanParameter("webuiAjax", 
        (woodstock4_3Config.webuiAjax != null) ? woodstock4_3Config.webuiAjax : false)
};
