/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 */

woodstock4_3._dojo.provide("woodstock4_3.widget._xhr.progressBar");

woodstock4_3._dojo.require("woodstock4_3.json");
woodstock4_3._dojo.require("woodstock4_3.widget.common");
woodstock4_3._dojo.require("woodstock4_3.widget.progressBar");
woodstock4_3._dojo.require("woodstock4_3.widget._xhr.common");

/**
 * @class This class contains functions to obtain data asynchronously using JSF
 * Extensions as the underlying transfer protocol.
 * @static
 * @private
 */
woodstock4_3.widget._xhr.progressBar =  {
    /**
     * This function is used to process progress events with Object literals.
     *
     * @param props Key-Value pairs of properties.
     * @config {String} id The HTML element Id.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _processProgressEvent: function(props) {
        if (props == null) {
            return false;
        }

        // Generate AJAX request.
        woodstock4_3.widget._xhr.common._doRequest({
            id: props.id,
            callback: woodstock4_3.widget._xhr.progressBar._progressCallback,
            xjson: {
                id: props.id,
                event: "progress",
                taskState: props.taskState,
                execute: props.id // Need to decode hidden field.
            }
        });
        return true;
    },

    /**
     * This function is used to update progress.
     *
     * @param {String} id The HTML widget Id.
     * @param {String} content The content returned by the AJAX response.
     * @param {Object} closure The closure argument provided to the Ajax transaction.
     * @param {Object} xjson The xjson header provided to the Ajax transaction.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _progressCallback: function(id, content, closure, xjson) {
        if (id == null || content == null) {
            return false;
        }

        // Parse JSON text.
        var props = woodstock4_3.json.parse(content);

        // Set progress.
        var widget = woodstock4_3.widget.common.getWidget(id);
        widget.setProgress({
            failedStateText : props.failedStateText,
            logMessage : props.logMessage,
            progress : props.progress,
            status: props.status,
            taskState : props.taskState,
            topText : props.topText
        });

        // Publish an event for custom AJAX implementations to listen for.
        woodstock4_3._dojo.publish(
            woodstock4_3.widget.progressBar.event.progress.endTopic, [props]);
        return true;
    }
};

// Listen for Widget events.
woodstock4_3._dojo.subscribe(woodstock4_3.widget.progressBar.event.progress.beginTopic,
    woodstock4_3.widget._xhr.progressBar, "_processProgressEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.progressBar.event.refresh.beginTopic,
    woodstock4_3.widget._xhr.common, "_processRefreshEvent");
