/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 */

woodstock4_3._dojo.provide("woodstock4_3.widget._xhr.tableRowGroup");

woodstock4_3._dojo.require("woodstock4_3.json");
woodstock4_3._dojo.require("woodstock4_3.xhr");
woodstock4_3._dojo.require("woodstock4_3.widget.common");
woodstock4_3._dojo.require("woodstock4_3.widget._xhr.common");
woodstock4_3._dojo.require("woodstock4_3.widget.tableRowGroup");

/**
 * @class This class contains functions to obtain data asynchronously using XHR
 * as the underlying transfer protocol.
 * @static
 * @private
 */
woodstock4_3.widget._xhr.tableRowGroup = {
    /**
     * This function is used to process scroll events with Object literals.
     *
     * @param props Key-Value pairs of properties.
     * @config {String} id The HTML element Id.
     * @config {int} row The first row to be rendered.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _processScrollEvent: function(props) {
        if (props == null) {
            return false;
        }

        // Ensure URL has been provided.
        if (woodstock4_3._base.config.ajax.url == null) {
            console.error("URL for Ajax transaction not provided.");
            return false
        }

        // Get form.
        var form = woodstock4_3.widget.common._getForm(
            document.getElementById(props.id));
        if (form == null) {
            form = document.forms[0];
        }

        // Pass through variables.
        var _id = props.id;
        var closure = {};
        var xjson = {
            id: props.id,
            event: "scroll",
            execute: "none",
            first: props.first
        };

        // Generate AJAX request.
        woodstock4_3.xhr.get({
            error: function(content, ioArgs) {
                console.error("HTTP status code: ", ioArgs.xhr.status);
                return content;
            },
            form: form,
            headers: {
                "X-JSON": woodstock4_3.json.stringify(xjson)
            },
            load: function(content, ioArgs) {
                woodstock4_3.widget._xhr.tableRowGroup._scrollCallback(_id, content, closure, xjson);
                return content;
            },
            timeout: 5000, // Time in milliseconds
            url: woodstock4_3._base.config.ajax.url
        });
        return true;
    },
    
    /**
     * This function is used to process scroll events with Object literals.
     *
     * @param props Key-Value pairs of properties.
     * @config {String} id The HTML element Id.
     * @config {int} row The first row to be rendered.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _processSortEvent: function(props) {
        if (props == null) {
            return false;
        }

        // Ensure URL has been provided.
        if (woodstock4_3._base.config.ajax.url == null) {
            console.error("URL for Ajax transaction not provided.");
            return false
        }

        // Get form.
        var form = woodstock4_3.widget.common._getForm(
            document.getElementById(props.id));
        if (form == null) {
            form = document.forms[0];
        }

        // Pass through variables.
        var _id = props.id;
        var closure = {};
        var xjson = {
            id: props.id,
            event: "sort",
            execute: "none",
            colId: props.tablecolId,
            sortOrder: props.sortOrder
        };

        // Generate AJAX request.
        woodstock4_3.xhr.get({
            error: function(content, ioArgs) {
                console.error("HTTP status code: ", ioArgs.xhr.status);
                return content;
            },
            form: form,
            headers: {
                "X-JSON": woodstock4_3.json.stringify(xjson)
            },
            load: function(content, ioArgs) {
                woodstock4_3.widget._xhr.tableRowGroup._sortCallback(_id, content, closure, xjson);
                return content;
            },
            timeout: 5000, // Time in milliseconds
            url: woodstock4_3._base.config.ajax.url
        });
        return true;
    },

    /**
     * This function is used to update widgets.
     *
     * @param {String} id The HTML widget Id.
     * @param {String} content The content returned by the AJAX response.
     * @param {Object} closure The closure argument provided to the Ajax transaction.
     * @param {Object} xjson The xjson header provided to the Ajax transaction.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _scrollCallback: function(id, content, closure, xjson) {
        if (id == null || content == null) {
            return false;
        }

        // Parse JSON text.
        var props = woodstock4_3.json.parse(content);

        // Reject duplicate AJAX requests.
        var widget = woodstock4_3.widget.common.getWidget(id);
        if (widget.first != xjson.first) {
            return false;
        }        
        // Add rows.
        widget.addRows(props.rows);

        // Publish an event for custom AJAX implementations to listen for.
        woodstock4_3._dojo.publish(
            woodstock4_3.widget.tableRowGroup.event.scroll.endTopic, [props]);
        return true;
    },

    /**
     * This function is used to update widgets.
     *
     * @param {String} id The HTML widget Id.
     * @param {String} content The content returned by the AJAX response.
     * @param {Object} closure The closure argument provided to the Ajax transaction.
     * @param {Object} xjson The xjson header provided to the Ajax transaction.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _sortCallback: function(id, content, closure, xjson) {
        if (id == null || content == null) {
            return false;
        }

        // Parse JSON text.
        var props = woodstock4_3.json.parse(content);

        // Reject duplicate AJAX requests.
        var widget = woodstock4_3.widget.common.getWidget(id); 
        widget.setProps(props);
  
        // Publish an event for custom AJAX implementations to listen for.
        woodstock4_3._dojo.publish(
            woodstock4_3.widget.tableRowGroup.event.sort.endTopic, [props]);
        return true;
    }
};
    
// Listen for Widget events.
woodstock4_3._dojo.subscribe(woodstock4_3.widget.tableRowGroup.event.refresh.beginTopic,
    woodstock4_3.widget._xhr.common, "_processRefreshEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.tableRowGroup.event.scroll.beginTopic,
    woodstock4_3.widget._xhr.tableRowGroup, "_processScrollEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.tableRowGroup.event.pagination.next.beginTopic,
    woodstock4_3.widget._xhr.tableRowGroup, "_processScrollEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.tableRowGroup.event.sort.beginTopic,
    woodstock4_3.widget._xhr.tableRowGroup, "_processSortEvent");
