/**
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License). You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at https://woodstock.dev.java.net/public/CDDLv1.0.html.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 */

woodstock4_3._dojo.provide("woodstock4_3.widget._xhr.textField");

woodstock4_3._dojo.require("woodstock4_3.json");
woodstock4_3._dojo.require("woodstock4_3.widget.common");
woodstock4_3._dojo.require("woodstock4_3.widget.textField");
woodstock4_3._dojo.require("woodstock4_3.widget._xhr.common");

/**
 * @class This class contains functions to obtain data asynchronously using JSF
 * Extensions as the underlying transfer protocol.
 * @static
 * @private
 */
woodstock4_3.widget._xhr.textField = {
    /**
     * This function is used to update widgets with new autoComplete options list.
     *
     * @param {String} id The HTML widget Id.
     * @param {String} content The content returned by the AJAX response.
     * @param {Object} closure The closure argument provided to the Ajax transaction.
     * @param {Object} xjson The xjson header provided to the Ajax transaction.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _autoCompleteCallback: function(elementId, content, closure, xjson) {
        if (elementId == null || content == null) {
            return false;
        }
        
        // Parse JSON text.
        var props = woodstock4_3.json.parse(content);

        // Update text field.
        var widget = woodstock4_3.widget.common.getWidget(elementId);
        widget.setProps(props);       


        // Publish an event for custom AJAX implementations to listen for.
        woodstock4_3._dojo.publish(
            woodstock4_3.widget.textField.event.autoComplete.endTopic, [props]);
        return true;
    },

    /**
     * This function is used to process autoComplete events.
     *
     * @param props Key-Value pairs of properties.
     * @config {String} id The HTML element Id.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _processAutoCompleteEvent: function(props) {
        if (props == null) {
            return false;
        }

        // Generate AJAX request.
        woodstock4_3.widget._xhr.common._doRequest({
            id: props.id,
            callback: woodstock4_3.widget._xhr.textField._autoCompleteCallback,
            xjson: {
                id: props.id,
                event: "autocomplete",
                execute: props.id
            }
        });
        return true;
    },  

    /**
     * This function is used to process validation events with Object literals.
     *
     * @param props Key-Value pairs of properties.
     * @config {String} id The HTML element Id.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _processValidationEvent: function(props) {
        if (props == null) {
            return false;
        }

        // Generate AJAX request.
        woodstock4_3.widget._xhr.common._doRequest({
            id: props.id,
            callback: woodstock4_3.widget._xhr.textField._validationCallback,
            xjson: {
                id: props.id,
                event: "validate",
                execute: props.id
            }
        });
        return true;
    },  

    /**
     * This function is used to update widgets.
     *
     * @param {String} id The HTML widget Id.
     * @param {String} content The content returned by the AJAX response.
     * @param {Object} closure The closure argument provided to the Ajax transaction.
     * @param {Object} xjson The xjson header provided to the Ajax transaction.
     * @return {boolean} true if successful; otherwise, false.
     * @private
     */
    _validationCallback: function(elementId, content, closure, xjson) {
        if (elementId == null || content == null) {
            return false;
        }
        
        // Parse JSON text.
        var props = woodstock4_3.json.parse(content);

        // Update text field.
        var widget = woodstock4_3.widget.common.getWidget(elementId);
        widget.setProps({
            valid: props.valid,
            errorImage: {
                title: props.detail
            }
        });

        // Notify decoupled widgets.
        if (widget.notify) {
            // Update each given client ID.
            for (var i = 0; i < widget.notify.length; i++) {
                // Get widget associated with client ID.
                var curWidget = woodstock4_3.widget.common.getWidget(widget.notify[i]);
                if (curWidget && typeof curWidget._notify == "function") {
                    curWidget._notify(props);
                }
            }
        }

        // Publish an event for custom AJAX implementations to listen for.
        woodstock4_3._dojo.publish(
            woodstock4_3.widget.textField.event.validation.endTopic, [props]);
        return true;
    }
};

// Listen for Widget events.
woodstock4_3._dojo.subscribe(woodstock4_3.widget.textField.event.refresh.beginTopic,
    woodstock4_3.widget._xhr.common, "_processRefreshEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.textField.event.state.beginTopic,
    woodstock4_3.widget._xhr.common, "_processStateEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.textField.event.submit.beginTopic,
    woodstock4_3.widget._xhr.common, "_processSubmitEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.textField.event.validation.beginTopic,
    woodstock4_3.widget._xhr.textField, "_processValidationEvent");
woodstock4_3._dojo.subscribe(woodstock4_3.widget.textField.event.autoComplete.beginTopic,
    woodstock4_3.widget._xhr.textField, "_processAutoCompleteEvent");
