/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.filter;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.keyinfo.KeyIdentifierStrategy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.saml.SAMLException;
import com.sun.xml.wss.saml.assertion.saml11.jaxb10.Assertion;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExportSamlAssertionFilter {
    public static void process(FilterProcessingContext context) throws XWSSecurityException {
        try {
            SecurableSoapMessage secureMessage = context.getSecurableSoapMessage();
            SecurityHeader securityHeader = secureMessage.findOrCreateSecurityHeader();
            AuthenticationTokenPolicy policy = (AuthenticationTokenPolicy)context.getSecurityPolicy();
            AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.getFeatureBinding();
            if (samlPolicy.getAssertionType() != "SV") {
                throw new XWSSecurityException("Internal Error: ExportSamlAssertionFilter called for HOK assertion");
            }
            samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.getFeatureBinding();
            samlPolicy.isReadOnly(true);
            DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context.getPolicyContext());
            dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
            dynamicContext.inBoundMessage(false);
            AuthenticationTokenPolicy.SAMLAssertionBinding resolvedPolicy = context.getSecurityEnvironment().populateSAMLPolicy(context.getExtraneousProperties(), samlPolicy, dynamicContext);
            com.sun.xml.wss.saml.Assertion _assertion = null;
            try {
                _assertion = System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null ? com.sun.xml.wss.saml.assertion.saml11.jaxb20.Assertion.fromElement(resolvedPolicy.getAssertion()) : Assertion.fromElement(resolvedPolicy.getAssertion());
            }
            catch (SAMLException ex) {
                // empty catch block
            }
            Element _authorityBinding = resolvedPolicy.getAuthorityBinding();
            if (_assertion == null && _authorityBinding == null) {
                throw new XWSSecurityException("None of SAML Assertion, SAML AuthorityBinding information was set into  the Policy by the CallbackHandler");
            }
            if (_assertion != null) {
                if (_authorityBinding == null) {
                    if (System.getProperty("com.sun.xml.wss.saml.binding.jaxb") == null) {
                        ((com.sun.xml.wss.saml.assertion.saml11.jaxb20.Assertion)_assertion).toElement((Node)((Object)securityHeader));
                    } else {
                        ((Assertion)_assertion).toElement((Node)((Object)securityHeader));
                    }
                    HashMap tokenCache = context.getTokenCache();
                    tokenCache.put(_assertion.getAssertionID(), _assertion);
                } else if (null == resolvedPolicy.getSTRID()) {
                    throw new XWSSecurityException("Unsupported configuration: required wsu:Id value  for SecurityTokenReference to Remote SAML Assertion not found  in Policy");
                }
            }
            if (null != resolvedPolicy.getSTRID()) {
                if (_assertion == null && null == resolvedPolicy.getAssertionId()) {
                    throw new XWSSecurityException("None of SAML Assertion, SAML Assertion Id information was set into  the Policy by the CallbackHandler");
                }
                String assertionId = resolvedPolicy.getAssertionId();
                if (_assertion != null) {
                    assertionId = _assertion.getAssertionID();
                }
                SecurityTokenReference tokenRef = new SecurityTokenReference((Document)secureMessage.getSOAPPart());
                tokenRef.setWsuId(resolvedPolicy.getSTRID());
                if (_authorityBinding != null) {
                    tokenRef.setSamlAuthorityBinding(_authorityBinding, (Document)secureMessage.getSOAPPart());
                }
                KeyIdentifierStrategy strat = new KeyIdentifierStrategy(assertionId);
                strat.insertKey(tokenRef, context.getSecurableSoapMessage());
                securityHeader.insertHeaderBlock(tokenRef);
            }
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }
}

