/*
 * Decompiled with CFR 0.152.
 */
package com.surftools.BeanstalkClientImpl;

import com.surftools.BeanstalkClient.BeanstalkException;
import com.surftools.BeanstalkClientImpl.Request;
import com.surftools.BeanstalkClientImpl.Response;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ProtocolHandler {
    private static final byte[] CRLF = new byte[]{13, 10};
    private Socket socket;
    private boolean useBlockIO = false;

    ProtocolHandler(String host, int port) {
        try {
            this.socket = new Socket(host, port);
        }
        catch (Exception e) {
            throw new BeanstalkException(e.getMessage());
        }
    }

    Response processRequest(Request request) {
        this.validateRequest(request);
        Response response = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(request.getCommand().getBytes());
            baos.write(CRLF);
            if (request.getData() != null) {
                baos.write(request.getData());
                baos.write(CRLF);
            }
            baos.flush();
            os = this.socket.getOutputStream();
            os.write(baos.toByteArray());
            os.flush();
            baos.close();
            is = this.socket.getInputStream();
            String line = new String(this.readInputStream(is, 0));
            String[] tokens = line.split(" ");
            if (tokens == null || tokens.length == 0) {
                throw new BeanstalkException("no response");
            }
            response = new Response();
            response.setResponseLine(line);
            String status = tokens[0];
            response.setStatus(status);
            if (tokens.length > 1) {
                response.setReponse(tokens[1]);
            }
            this.setState(request, response, status);
            switch (request.getExpectedResponse()) {
                case Map: {
                    if (response.isMatchError()) break;
                    response.setData(this.parseForMap(is));
                    break;
                }
                case List: {
                    response.setData(this.parseForList(is));
                    break;
                }
                case ByteArray: {
                    if (response.isMatchError()) break;
                    int length = 0;
                    if (request.getExpectedDataLengthIndex() > 0 && tokens.length > request.getExpectedDataLengthIndex()) {
                        try {
                            length = Integer.parseInt(tokens[request.getExpectedDataLengthIndex()]);
                        }
                        catch (NumberFormatException ex) {
                            length = 0;
                        }
                    }
                    byte[] data = this.readInputStream(is, length);
                    response.setData(data);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new BeanstalkException(e.getMessage());
        }
        return response;
    }

    private byte[] readInputStream(InputStream is, int expectedLength) {
        if (is == null) {
            return null;
        }
        byte[] data = expectedLength > 0 && this.useBlockIO ? this.readInputStreamBurstMode(is, expectedLength) : this.readInputStreamSlowMode(is);
        return data;
    }

    private byte[] readInputStreamBurstMode(InputStream is, int length) {
        try {
            byte[] data = new byte[length];
            int off = 0;
            int toRead = length - off;
            while (toRead > 0) {
                int readLength = is.read(data, off, toRead);
                if (readLength == -1) {
                    throw new BeanstalkException(String.format("The end of InputStream is reached - %d bytes expected, %d bytes read", length, off + readLength));
                }
                toRead = length - (off += readLength);
            }
            byte br = (byte)is.read();
            byte bn = (byte)is.read();
            if (br != 13 || bn != 10) {
                throw new BeanstalkException("The end of InputStream is reached - End of line expected, but not found");
            }
            return data;
        }
        catch (IOException ex) {
            throw new BeanstalkException(ex.getMessage());
        }
    }

    private byte[] readInputStreamSlowMode(InputStream is) {
        boolean lastByteWasReturnByte = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            while (true) {
                int intB = is.read();
                byte b = (byte)intB;
                if (intB == -1) {
                    throw new BeanstalkException("The end of InputStream is reached");
                }
                if (b == 10 && lastByteWasReturnByte) break;
                if (b == 13) {
                    lastByteWasReturnByte = true;
                    continue;
                }
                if (lastByteWasReturnByte) {
                    lastByteWasReturnByte = false;
                    baos.write(13);
                }
                baos.write(b);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new BeanstalkException(e.getMessage());
        }
    }

    private void validateRequest(Request request) {
        if (request == null) {
            throw new BeanstalkException("null request");
        }
        String command = request.getCommand();
        if (command == null || command.length() == 0) {
            throw new BeanstalkException("null or empty command");
        }
        String[] validStates = request.getValidStates();
        if (validStates == null || validStates.length == 0) {
            throw new BeanstalkException("null or empty validStates");
        }
    }

    private void setState(Request request, Response response, String status) {
        for (String s : request.getValidStates()) {
            if (!status.equals(s)) continue;
            response.setMatchOk(true);
            break;
        }
        if (!response.isMatchOk() && request.getErrorStates() != null) {
            for (String s : request.getErrorStates()) {
                if (!status.equals(s)) continue;
                response.setMatchError(true);
                break;
            }
        }
        if (!response.isMatchOk() && !response.isMatchError()) {
            throw new BeanstalkException(status);
        }
    }

    private Map<String, String> parseForMap(InputStream is) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String line = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null && line.length() != 0) {
                String[] values = line.split(": ");
                if (values.length != 2) continue;
                map.put(values[0], values[1]);
            }
        }
        catch (Exception e) {
            throw new BeanstalkException(e.getMessage());
        }
        return map;
    }

    private List<String> parseForList(InputStream is) {
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null && line.length() != 0) {
                if (line.equals("---")) continue;
                list.add(line.substring(2));
            }
        }
        catch (Exception e) {
            throw new BeanstalkException(e.getMessage());
        }
        return list;
    }

    public void close() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                throw new BeanstalkException(e.getMessage());
            }
        }
    }

    public void setUseBlockIO(boolean useBlockIO) {
        this.useBlockIO = useBlockIO;
    }

    public boolean isUseBlockIO() {
        return this.useBlockIO;
    }
}

