/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnershipDescription
implements Serializable {
    public static final OwnershipDescription DISABLED_DESCR = new OwnershipDescription(false, "");
    boolean ownershipEnabled;
    String primaryOwnerId;
    Set<String> coownersIds;

    public OwnershipDescription(boolean ownershipEnabled, @Nonnull String primaryOwnerId) {
        this(ownershipEnabled, primaryOwnerId, null);
    }

    public OwnershipDescription(boolean ownershipEnabled, @Nullable String primaryOwnerId, @Nullable Collection<String> coownersIds) {
        this.ownershipEnabled = ownershipEnabled;
        this.primaryOwnerId = primaryOwnerId;
        this.coownersIds = coownersIds != null ? new TreeSet<String>(coownersIds) : new TreeSet();
    }

    public void assign(@Nonnull OwnershipDescription descr) {
        this.ownershipEnabled = descr.ownershipEnabled;
        this.primaryOwnerId = descr.primaryOwnerId;
        this.coownersIds = descr.coownersIds;
    }

    public String toString() {
        if (!this.ownershipEnabled) {
            return "ownership:disabled";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("owner=");
        builder.append(this.primaryOwnerId);
        if (!this.coownersIds.isEmpty()) {
            builder.append(" co-owners:[");
            for (String coownerId : this.coownersIds) {
                builder.append(coownerId);
                builder.append(' ');
            }
            builder.append(']');
        }
        return builder.toString();
    }

    public boolean isOwnershipEnabled() {
        return this.ownershipEnabled;
    }

    @Nonnull
    public String getPrimaryOwnerId() {
        return this.ownershipEnabled ? this.primaryOwnerId : User.getUnknown().getId();
    }

    @CheckForNull
    public User getPrimaryOwner() {
        return User.get((String)this.primaryOwnerId, (boolean)false, null);
    }

    @Nonnull
    public Set<String> getCoownersIds() {
        return this.coownersIds;
    }

    @Nonnull
    public static OwnershipDescription Parse(JSONObject formData) throws Descriptor.FormException {
        return OwnershipDescription.parseJSON(formData);
    }

    @Nonnull
    public static OwnershipDescription parseJSON(JSONObject formData) throws Descriptor.FormException {
        String primaryOwner = formData.getString("primaryOwner");
        TreeSet<String> coOwnersSet = new TreeSet<String>();
        if (formData.has("coOwners")) {
            JSONObject coOwners = formData.optJSONObject("coOwners");
            if (coOwners == null) {
                for (Object obj : formData.getJSONArray("coOwners")) {
                    OwnershipDescription.addUser(coOwnersSet, (JSONObject)obj);
                }
            } else {
                OwnershipDescription.addUser(coOwnersSet, coOwners);
            }
        }
        return new OwnershipDescription(true, primaryOwner, coOwnersSet);
    }

    private static void addUser(Set<String> target, JSONObject userObj) throws Descriptor.FormException {
        String userId = Util.fixEmptyAndTrim((String)userObj.getString("coOwner"));
        if (userId != null) {
            target.add(userId);
        }
    }

    public boolean isOwner(User user, boolean acceptCoowners) {
        if (user == null) {
            return false;
        }
        if (this.isPrimaryOwner(user)) {
            return true;
        }
        return acceptCoowners ? this.coownersIds.contains(user.getId()) : false;
    }

    public boolean hasPrimaryOwner() {
        return this.ownershipEnabled && this.getPrimaryOwner() != null;
    }

    public boolean isPrimaryOwner(User user) {
        return user != null && user == this.getPrimaryOwner();
    }

    public static boolean isEnabled(OwnershipDescription descr) {
        return descr != null && descr.ownershipEnabled;
    }
}

