/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerJobProperty;
import com.synopsys.arc.jenkins.plugins.ownership.security.itemspecific.ItemSpecificSecurity;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.AccessRightsFilter;
import hudson.matrix.MatrixConfiguration;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.User;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobOwnerHelper
extends AbstractOwnershipHelper<Job<?, ?>> {
    public static final JobOwnerHelper Instance = new JobOwnerHelper();

    @CheckForNull
    public static JobOwnerJobProperty getOwnerProperty(@Nonnull Job<?, ?> job) {
        JobProperty prop = job.getProperty(JobOwnerJobProperty.class);
        if (prop != null) {
            return (JobOwnerJobProperty)prop;
        }
        if (job instanceof MatrixConfiguration) {
            return JobOwnerHelper.getOwnerProperty(((MatrixConfiguration)job).getParent());
        }
        return null;
    }

    public static boolean isUserExists(@Nonnull User user) {
        assert (user != null);
        return JobOwnerHelper.isUserExists(user.getId());
    }

    public static boolean isUserExists(@Nonnull String userIdOrFullName) {
        assert (userIdOrFullName != null);
        return User.get((String)userIdOrFullName, (boolean)false, null) != null;
    }

    @Override
    @Nonnull
    public OwnershipDescription getOwnershipDescription(@Nonnull Job<?, ?> job) {
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty(job);
        return prop != null ? prop.getOwnership() : OwnershipDescription.DISABLED_DESCR;
    }

    public static void setOwnership(@Nonnull Job<?, ?> job, @CheckForNull OwnershipDescription descr) throws IOException {
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty(job);
        if (prop == null) {
            prop = new JobOwnerJobProperty(descr, null);
            job.addProperty((JobProperty)prop);
        } else {
            prop.setOwnershipDescription(descr);
        }
    }

    public static void setProjectSpecificSecurity(@Nonnull Job<?, ?> job, @CheckForNull ItemSpecificSecurity security) throws IOException {
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty(job);
        if (prop == null) {
            throw new IOException("Ownership is not configured for " + job);
        }
        prop.setItemSpecificSecurity(security);
    }

    @Override
    @Nonnull
    public Collection<User> getPossibleOwners(@Nonnull Job<?, ?> item) {
        if (OwnershipPlugin.getInstance().isRequiresConfigureRights()) {
            AccessRightsFilter filter = new AccessRightsFilter((AccessControlled)item, Job.CONFIGURE);
            return UserCollectionFilter.filterUsers(User.getAll(), true, filter);
        }
        return User.getAll();
    }

    @Override
    public String getItemTypeName(Job<?, ?> item) {
        return "job";
    }

    @Override
    public String getItemDisplayName(Job<?, ?> item) {
        return item.getFullDisplayName();
    }

    @Override
    public String getItemURL(Job<?, ?> item) {
        return item.getUrl();
    }
}

