/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.ItemOwnershipAction;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerJobProperty;
import com.synopsys.arc.jenkins.plugins.ownership.security.itemspecific.ItemSpecificSecurity;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.security.Permission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobOwnerJobAction
extends ItemOwnershipAction<Job<?, ?>> {
    public JobOwnerJobAction(Job<?, ?> job) {
        super(job);
    }

    @Nonnull
    public JobOwnerHelper helper() {
        return JobOwnerHelper.Instance;
    }

    public Job<?, ?> getJob() {
        return (Job)this.getDescribedItem();
    }

    @Override
    public Permission getOwnerPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public Permission getProjectSpecificPermission() {
        return OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP;
    }

    @Override
    public OwnershipDescription getOwnership() {
        return this.helper().getOwnershipDescription((Job)this.getDescribedItem());
    }

    @CheckForNull
    public ItemSpecificSecurity getItemSpecificSecurity() {
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty((Job)this.getDescribedItem());
        if (prop != null && prop.hasItemSpecificSecurity()) {
            return prop.getItemSpecificSecurity();
        }
        return JobOwnerJobAction.getGlobalItemSpecificSecurity();
    }

    @CheckForNull
    private static ItemSpecificSecurity getGlobalItemSpecificSecurity() {
        return OwnershipPlugin.getInstance().getDefaultJobsSecurity();
    }

    public boolean hasItemSpecificSecurity() {
        JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty((Job)this.getDescribedItem());
        return prop != null && prop.hasItemSpecificSecurity();
    }

    public ItemSpecificSecurity.ItemSpecificDescriptor getItemSpecificDescriptor() {
        return ItemSpecificSecurity.DESCRIPTOR;
    }

    @Override
    public boolean actionIsAvailable() {
        return ((Job)this.getDescribedItem()).hasPermission(OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP);
    }

    public HttpResponse doOwnersSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        ((Job)this.getDescribedItem()).hasPermission(OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP);
        JSONObject jsonOwnership = req.getSubmittedForm().getJSONObject("owners");
        OwnershipDescription descr = OwnershipDescription.parseJSON(jsonOwnership);
        JobOwnerHelper.setOwnership((Job)this.getDescribedItem(), descr);
        return HttpResponses.redirectViaContextPath((String)((Job)this.getDescribedItem()).getUrl());
    }

    public HttpResponse doProjectSpecificSecuritySubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        ((Job)this.getDescribedItem()).hasPermission(OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP);
        JSONObject form = req.getSubmittedForm();
        if (form.containsKey((Object)"itemSpecificSecurity")) {
            JSONObject jsonSpecificSecurity = req.getSubmittedForm().getJSONObject("itemSpecificSecurity");
            ItemSpecificSecurity specific = ItemSpecificSecurity.DESCRIPTOR.newInstance(req, jsonSpecificSecurity);
            JobOwnerHelper.setProjectSpecificSecurity((Job)this.getDescribedItem(), specific);
        } else {
            JobOwnerHelper.setProjectSpecificSecurity((Job)this.getDescribedItem(), null);
        }
        return HttpResponses.redirectViaContextPath((String)((Job)this.getDescribedItem()).getUrl());
    }

    public HttpResponse doRestoreDefaultSpecificSecuritySubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        ((Job)this.getDescribedItem()).hasPermission(OwnershipPlugin.MANAGE_ITEMS_OWNERSHIP);
        ItemSpecificSecurity defaultJobsSecurity = OwnershipPlugin.getInstance().getDefaultJobsSecurity();
        ItemSpecificSecurity val = defaultJobsSecurity != null ? defaultJobsSecurity.clone() : null;
        JobOwnerHelper.setProjectSpecificSecurity((Job)this.getDescribedItem(), val);
        return HttpResponses.redirectViaContextPath((String)((Job)this.getDescribedItem()).getUrl());
    }
}

