/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.User;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputerOwnerHelper
extends AbstractOwnershipHelper<Computer> {
    static final ComputerOwnerHelper Instance = new ComputerOwnerHelper();

    public static ComputerOwnerHelper getInstance() {
        return Instance;
    }

    @Override
    public OwnershipDescription getOwnershipDescription(@Nonnull Computer item) {
        Node node = item.getNode();
        return node != null ? NodeOwnerHelper.Instance.getOwnershipDescription(node) : OwnershipDescription.DISABLED_DESCR;
    }

    @Override
    public Collection<User> getPossibleOwners(@Nonnull Computer computer) {
        Node node = computer.getNode();
        return node != null ? NodeOwnerHelper.Instance.getPossibleOwners(node) : EMPTY_USERS_COLLECTION;
    }

    public static void setOwnership(@Nonnull Computer computer, @CheckForNull OwnershipDescription descr) throws IOException {
        Node node = computer.getNode();
        if (node == null) {
            throw new IOException("Cannot set ownership. Probably, the node has been renamed or deleted.");
        }
        NodeOwnerHelper.setOwnership(node, descr);
    }

    @Override
    public String getItemTypeName(Computer item) {
        return "computer";
    }

    @Override
    public String getItemDisplayName(Computer item) {
        return item.getDisplayName();
    }

    @Override
    public String getItemURL(Computer item) {
        return item.getUrl();
    }
}

