/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.ComputerOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.OwnerNodeProperty;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.AccessRightsFilter;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeOwnerHelper
extends AbstractOwnershipHelper<Node> {
    public static final NodeOwnerHelper Instance = new NodeOwnerHelper();
    static final String ITEM_TYPE_NAME = "node";

    @CheckForNull
    public static OwnerNodeProperty getOwnerProperty(@Nonnull Node node) {
        NodeProperty prop = (NodeProperty)node.getNodeProperties().get(OwnerNodeProperty.class);
        return prop != null ? (OwnerNodeProperty)prop : null;
    }

    @Override
    public OwnershipDescription getOwnershipDescription(Node item) {
        if (item == null) {
            return OwnershipDescription.DISABLED_DESCR;
        }
        OwnerNodeProperty prop = NodeOwnerHelper.getOwnerProperty(item);
        return prop != null ? prop.getOwnership() : OwnershipDescription.DISABLED_DESCR;
    }

    @Override
    public Collection<User> getPossibleOwners(Node item) {
        if (OwnershipPlugin.getInstance().isRequiresConfigureRights()) {
            AccessRightsFilter filter = new AccessRightsFilter((AccessControlled)item, Computer.CONFIGURE);
            return UserCollectionFilter.filterUsers(User.getAll(), true, filter);
        }
        return User.getAll();
    }

    public static void setOwnership(@Nonnull Node node, @CheckForNull OwnershipDescription descr) throws IOException {
        OwnerNodeProperty prop = NodeOwnerHelper.getOwnerProperty(node);
        if (prop == null) {
            prop = new OwnerNodeProperty(node, descr);
            node.getNodeProperties().add((Object)prop);
        } else {
            prop.setOwnershipDescription(descr);
        }
    }

    @Override
    public String getItemTypeName(Node item) {
        return ITEM_TYPE_NAME;
    }

    @Override
    public String getItemDisplayName(Node item) {
        return item.getDisplayName();
    }

    @Override
    public String getItemURL(Node item) {
        Computer c = item.toComputer();
        return c != null ? ComputerOwnerHelper.Instance.getItemURL(c) : null;
    }
}

