/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.security.authorizeproject;

import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.User;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategy;
import org.jenkinsci.plugins.authorizeproject.AuthorizeProjectStrategyDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnershipAuthorizeProjectStrategy
extends AuthorizeProjectStrategy {
    @DataBoundConstructor
    public OwnershipAuthorizeProjectStrategy() {
    }

    public Authentication authenticate(AbstractProject<?, ?> ap, Queue.Item item) {
        OwnershipDescription d = JobOwnerHelper.Instance.getOwnershipDescription((Job<?, ?>)ap);
        if (!d.hasPrimaryOwner()) {
            return Jenkins.ANONYMOUS;
        }
        User owner = User.get((String)d.getPrimaryOwnerId(), (boolean)false, Collections.emptyMap());
        if (owner == null) {
            return Jenkins.ANONYMOUS;
        }
        try {
            Authentication auth = owner.impersonate();
            return auth != null ? auth : Jenkins.ANONYMOUS;
        }
        catch (UsernameNotFoundException ex) {
            return Jenkins.ANONYMOUS;
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AuthorizeProjectStrategyDescriptor {
        public String getDisplayName() {
            return Messages.Security_AuthorizeProject_OwnershipAuthorizeProjectStrategy_DisplayName();
        }
    }
}

