/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.security.rolestrategy;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipItem;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerJobProperty;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.OwnerNodeProperty;
import com.synopsys.arc.jenkins.plugins.rolestrategy.Macro;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleMacroExtension;
import com.synopsys.arc.jenkins.plugins.rolestrategy.RoleType;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;

abstract class AbstractOwnershipRoleMacro
extends RoleMacroExtension {
    public static final String NO_SID_SUFFIX = "NoSid";
    protected static final String AUTHENTICATED_SID = "authenticated";

    AbstractOwnershipRoleMacro() {
    }

    public boolean IsApplicable(RoleType roleType) {
        switch (roleType) {
            case Project: {
                return true;
            }
            case Slave: {
                return true;
            }
        }
        return false;
    }

    public static OwnershipDescription getOwnership(RoleType type, AccessControlled item) {
        IOwnershipItem ownership = null;
        switch (type) {
            case Project: {
                Job prj;
                JobOwnerJobProperty prop;
                if (!(item instanceof Job) || (prop = JobOwnerHelper.getOwnerProperty(prj = (Job)item)) == null) break;
                ownership = prop;
                break;
            }
            case Slave: {
                Computer comp;
                Node node;
                if (!(item instanceof Computer) || (node = (comp = (Computer)item).getNode()) == null) break;
                ownership = (IOwnershipItem)node.getNodeProperties().get(OwnerNodeProperty.class);
                break;
            }
        }
        return ownership != null ? ownership.getOwnership() : OwnershipDescription.DISABLED_DESCR;
    }

    public static boolean hasPermission(User user, RoleType type, AccessControlled item, Macro macro, boolean acceptCoowners) {
        if (user == null) {
            return false;
        }
        return AbstractOwnershipRoleMacro.getOwnership(type, item).isOwner(user, acceptCoowners);
    }
}

