/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import hudson.model.User;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class HTMLFormatter {
    @CheckForNull
    public static String formatEmailURI(@Nonnull String userId) {
        String email = UserStringFormatter.formatEmail(userId);
        if (email != null) {
            return "<a href=\"mailto://" + email + "\">&lt;" + email + "&gt;</a>";
        }
        return null;
    }

    @Nonnull
    public static String formatShortUserURI(@Nonnull String userId) {
        return HTMLFormatter.formatUserURI(userId, false);
    }

    @Nonnull
    public static String formatUserURI(@Nonnull String userId) {
        return HTMLFormatter.formatUserURI(userId, true);
    }

    @Nonnull
    public static String formatUserURI(@Nonnull String userId, boolean useLongFormat) {
        User usr = User.get((String)userId, (boolean)false, null);
        if (usr != null) {
            String userStr = useLongFormat ? usr.getDisplayName() : UserStringFormatter.formatShort(usr.getId());
            return "<a href=\"" + Jenkins.getInstance().getRootUrl() + "user/" + userId + "\">" + userStr + "</a>";
        }
        return userId + " (unregistered)";
    }
}

