/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import javax.annotation.Nonnull;

public class OwnershipDescriptionHelper {
    private OwnershipDescriptionHelper() {
    }

    @Nonnull
    public static String getOwnerID(@Nonnull OwnershipDescription descr) {
        return descr.getPrimaryOwnerId();
    }

    public static String getOwnerEmail(@Nonnull OwnershipDescription descr) {
        String ownerEmail = UserStringFormatter.formatEmail(descr.getPrimaryOwnerId());
        return ownerEmail != null ? ownerEmail : "";
    }

    @Nonnull
    public static String getCoOwnerIDs(@Nonnull OwnershipDescription descr) {
        StringBuilder coowners = new StringBuilder(OwnershipDescriptionHelper.getOwnerID(descr));
        for (String userId : descr.getCoownersIds()) {
            if (coowners.length() == 0) {
                coowners.append(",");
            }
            coowners.append(userId);
        }
        return coowners.toString();
    }

    public static String getCoOwnerEmails(@Nonnull OwnershipDescription descr) {
        StringBuilder coownerEmails = new StringBuilder(OwnershipDescriptionHelper.getOwnerEmail(descr));
        for (String userId : descr.getCoownersIds()) {
            String coownerEmail = UserStringFormatter.formatEmail(userId);
            if (coownerEmail == null) continue;
            if (coownerEmails.length() != 0) {
                coownerEmails.append(",");
            }
            coownerEmails.append(coownerEmail);
        }
        return coownerEmails.toString();
    }
}

