/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import hudson.model.User;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UserStringFormatter {
    public static final String UNKNOWN_USER_STRING = "N/A";

    @Nonnull
    public static String format(@CheckForNull User user) {
        return user != null ? user.getFullName() + " (" + user.getId() + ")" : UNKNOWN_USER_STRING;
    }

    @Nonnull
    public static String format(@Nonnull String userId) {
        return UserStringFormatter.format(User.get((String)userId, (boolean)false, null));
    }

    @Nonnull
    public static String formatShort(@CheckForNull String userId) {
        return userId != null && !userId.isEmpty() ? userId : UNKNOWN_USER_STRING;
    }

    @CheckForNull
    public static String formatEmail(@Nonnull String userId) {
        return UserStringFormatter.formatEmail(User.get((String)userId, (boolean)false, null));
    }

    @CheckForNull
    public static String formatEmail(@CheckForNull User user) {
        return user != null && user != User.getUnknown() ? OwnershipPlugin.getInstance().resolveEmail(user) : null;
    }
}

