/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import hudson.model.User;
import javax.annotation.Nonnull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UserWrapper {
    boolean isUser;
    User user;
    String macro;
    public static final String USER_MACRO_PREFIX = "@";

    public UserWrapper(@Nonnull User user) {
        this.isUser = true;
        this.user = user;
    }

    public UserWrapper(@Nonnull String userMacro) {
        if (userMacro.startsWith(USER_MACRO_PREFIX)) {
            this.isUser = false;
            this.macro = userMacro;
        } else {
            this.isUser = true;
            this.user = User.get((String)userMacro, (boolean)false, null);
        }
    }

    public boolean IsUser() {
        return this.isUser;
    }

    public String getId() {
        return this.isUser ? this.user.getId() : this.macro;
    }

    public String toString() {
        return this.isUser ? UserStringFormatter.format(this.user) : this.macro;
    }

    public boolean meetsMacro(String userId) {
        String comparedId;
        if (this.isUser) {
            if (this.user == null) {
                return false;
            }
            comparedId = this.user.getId();
        } else {
            User current = User.current();
            if (current == null) {
                return false;
            }
            comparedId = current.getId();
        }
        return comparedId.equals(userId);
    }
}

