/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util.ui;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.HTMLFormatter;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.ownership.util.mail.OwnershipMailHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OwnershipLayoutFormatter<TObjectType> {
    public abstract String formatUser(@Nonnull TObjectType var1, String var2);

    public String formatOwner(@Nonnull TObjectType item, String userId) {
        return this.formatUser(item, userId);
    }

    public String formatCoOwner(@Nonnull TObjectType item, String userId) {
        return this.formatUser(item, userId);
    }

    public abstract String formatContactOwnersLink(@Nonnull TObjectType var1, IOwnershipHelper var2);

    public abstract String formatContactAdminsLink(@Nonnull TObjectType var1, IOwnershipHelper var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultJobFormatter<TObjectType>
    extends OwnershipLayoutFormatter<TObjectType> {
        @Override
        public String formatUser(TObjectType item, String userId) {
            String userURI = HTMLFormatter.formatUserURI(userId, true);
            String userEmail = HTMLFormatter.formatEmailURI(userId);
            String userInfoHTML = userURI + (userEmail != null ? " " + userEmail : "");
            return userInfoHTML;
        }

        @Override
        public String formatContactOwnersLink(TObjectType item, IOwnershipHelper helper) {
            return OwnershipMailHelper.getContactOwnersMailToURL(item, helper);
        }

        @Override
        public String formatContactAdminsLink(TObjectType item, IOwnershipHelper helper) {
            return OwnershipMailHelper.getContactAdminsMailToURL(item, helper);
        }
    }
}

