/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipItem;
import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.security.itemspecific.ItemSpecificSecurity;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.ui.OwnershipLayoutFormatter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.AccessRightsFilter;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.User;
import hudson.security.AccessControlled;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobOwnerJobProperty
extends JobProperty<Job<?, ?>>
implements IOwnershipItem<Job<?, ?>> {
    OwnershipDescription ownership;
    ItemSpecificSecurity itemSpecificSecurity;

    @DataBoundConstructor
    public JobOwnerJobProperty(OwnershipDescription ownershipDescription, ItemSpecificSecurity security) {
        this.ownership = ownershipDescription;
        this.itemSpecificSecurity = security;
    }

    @Override
    public OwnershipDescription getOwnership() {
        return this.ownership != null ? this.ownership : OwnershipDescription.DISABLED_DESCR;
    }

    @Nonnull
    public ItemSpecificSecurity getItemSpecificSecurity() {
        return this.itemSpecificSecurity != null ? this.itemSpecificSecurity : OwnershipPlugin.getInstance().getDefaultJobsSecurity();
    }

    public boolean hasItemSpecificSecurity() {
        return this.itemSpecificSecurity != null;
    }

    public String getDisplayName(User usr) {
        return JobOwnerHelper.Instance.getDisplayName(usr);
    }

    public Collection<User> getUsers() {
        AccessRightsFilter filter = new AccessRightsFilter((AccessControlled)this.owner, Job.CONFIGURE);
        Collection<User> res = UserCollectionFilter.filterUsers(User.getAll(), true, filter);
        return res;
    }

    @Override
    public IOwnershipHelper<Job<?, ?>> helper() {
        return JobOwnerHelper.Instance;
    }

    @Override
    public Job<?, ?> getDescribedItem() {
        return this.owner;
    }

    public JobProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        return new JobOwnerJobProperty(this.ownership, this.itemSpecificSecurity);
    }

    public OwnershipLayoutFormatter<Job<?, ?>> getLayoutFormatter() {
        return OwnershipPlugin.getInstance().getOwnershipLayoutFormatterProvider().getLayoutFormatter(this.getDescribedItem());
    }

    public String toString() {
        return this.ownership.toString();
    }

    public void doOwnersSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        JSONObject formData = req.getSubmittedForm();
        JSONObject jsonOwnership = formData.getJSONObject("owners");
        this.setOwnershipDescription(OwnershipDescription.parseJSON(jsonOwnership));
    }

    public void setOwnershipDescription(@CheckForNull OwnershipDescription descr) throws IOException {
        this.ownership = descr;
        this.owner.save();
    }

    public void setItemSpecificSecurity(@CheckForNull ItemSpecificSecurity security) throws IOException {
        this.itemSpecificSecurity = security;
        this.owner.save();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public String getDisplayName() {
            return Messages.JobOwnership_Config_SectionTitle();
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }
    }
}

