/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.jobs;

import com.synopsys.arc.jenkins.plugins.ownership.Messages;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserWrapper;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.UserComparator;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.View;
import hudson.views.ViewJobFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnershipJobFilter
extends ViewJobFilter {
    private static final String MACRO_ME = "@Me";
    String ownerId;
    boolean acceptsCoowners;

    public String getOwnerName() {
        return this.ownerId;
    }

    public boolean isAcceptsCoowners() {
        return this.acceptsCoowners;
    }

    public boolean isSelected(UserWrapper usr) {
        return this.ownerId.equals(usr.getId());
    }

    @DataBoundConstructor
    public OwnershipJobFilter(String ownerName, boolean acceptCoowners) {
        this.ownerId = ownerName;
        this.acceptsCoowners = acceptCoowners;
    }

    public List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ArrayList<TopLevelItem> newList = new ArrayList<TopLevelItem>();
        UserWrapper userWrapper = new UserWrapper(this.ownerId);
        for (TopLevelItem item : added) {
            AbstractProject project;
            OwnershipDescription ownership;
            if (!(item instanceof AbstractProject) || !(ownership = JobOwnerHelper.Instance.getOwnershipDescription((Job<?, ?>)(project = (AbstractProject)item))).isOwnershipEnabled()) continue;
            boolean matches = false;
            if (userWrapper.meetsMacro(ownership.getPrimaryOwnerId())) {
                matches = true;
            }
            if (this.acceptsCoowners && !matches) {
                for (String coOwnerId : ownership.getCoownersIds()) {
                    if (!userWrapper.meetsMacro(coOwnerId)) continue;
                    matches = true;
                    break;
                }
            }
            if (!matches) continue;
            newList.add(item);
        }
        return newList;
    }

    public static Collection<UserWrapper> getAvailableUsers() {
        UserComparator comparator = new UserComparator();
        LinkedList userList = new LinkedList(User.getAll());
        Collections.sort(userList, comparator);
        ArrayList<UserWrapper> res = new ArrayList<UserWrapper>(userList.size() + 1);
        res.add(new UserWrapper(MACRO_ME));
        for (User user : userList) {
            res.add(new UserWrapper(user));
        }
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<ViewJobFilter> {
        public String getDisplayName() {
            return Messages.JobOwnership_Filter_DisplayName();
        }

        public ViewJobFilter newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String jobOwner = formData.getString("jobOwner");
            boolean acceptCoowners = formData.getBoolean("acceptsCoowners");
            OwnershipJobFilter instance = new OwnershipJobFilter(jobOwner, acceptCoowners);
            return instance;
        }
    }
}

